package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class PlatformElemViewer implements PlatformElem {
  public final Vertex viewedVertex;

  public PlatformElemViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "PlatformElem".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof PlatformElemViewer ? ((PlatformElemViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "PlatformElemViewer{" + getViewedVertex().toString() + "}";
  }
}
