package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface RoundRobinCommunicationModule extends InstrumentedCommunicationModule, VertexViewer {
  /**
   * getter for required property "allocatedWeights".
   * @return "allocatedWeights".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Map<String, Integer> getAllocatedWeights() {
    return getViewedVertex().getProperties().containsKey("allocatedWeights") ?
                    (Map<String, Integer>) getViewedVertex().getProperties().get("allocatedWeights").unwrap() :
                    null;
  }

  /**
   * setter for named required property "allocatedWeights".
   * @param allocatedWeights value for required property "allocatedWeights".
   */
  default void setAllocatedWeights(Map<String, Integer> allocatedWeights) {
    getViewedVertex().getProperties().put("allocatedWeights", VertexProperty.create(allocatedWeights));
  }

  /**
   * getter for required property "totalWeights".
   * @return "totalWeights".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Integer getTotalWeights() {
    return getViewedVertex().getProperties().containsKey("totalWeights") ?
                    (Integer) getViewedVertex().getProperties().get("totalWeights").unwrap() :
                    null;
  }

  /**
   * setter for named required property "totalWeights".
   * @param totalWeights value for required property "totalWeights".
   */
  default void setTotalWeights(Integer totalWeights) {
    getViewedVertex().getProperties().put("totalWeights", VertexProperty.create(totalWeights));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_ROUNDROBINCOMMUNICATIONMODULE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_ROUNDROBINCOMMUNICATIONMODULE)) return true;
    }
    return false;
  }

  static Optional<RoundRobinCommunicationModule> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new RoundRobinCommunicationModuleViewer(vertex)) : Optional.empty();
  }

  static Optional<RoundRobinCommunicationModule> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new RoundRobinCommunicationModuleViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static RoundRobinCommunicationModule enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_ROUNDROBINCOMMUNICATIONMODULE);
    vertex.ports.addAll(RoundRobinCommunicationModule.getRequiredPorts());
    for(String key : RoundRobinCommunicationModule.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, RoundRobinCommunicationModule.getRequiredProperties().get(key));
    }
    return new RoundRobinCommunicationModuleViewer(vertex);
  }

  static RoundRobinCommunicationModule enforce(VertexViewer viewer) {
    return RoundRobinCommunicationModule.enforce(viewer.getViewedVertex());
  }
}
