package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class RoundRobinCommunicationModuleViewer implements RoundRobinCommunicationModule {
  public final Vertex viewedVertex;

  public RoundRobinCommunicationModuleViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "RoundRobinCommunicationModule".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof RoundRobinCommunicationModuleViewer ? ((RoundRobinCommunicationModuleViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "RoundRobinCommunicationModuleViewer{" + getViewedVertex().toString() + "}";
  }
}
