package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface SynthetizableDigitalPorts extends DigitalModule, VertexViewer {
  /**
   * getter for required property "portProtocolAcronym".
   * @return "portProtocolAcronym".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Map<String, String> getPortProtocolAcronym() {
    return getViewedVertex().getProperties().containsKey("portProtocolAcronym") ?
                    (Map<String, String>) getViewedVertex().getProperties().get("portProtocolAcronym").unwrap() :
                    null;
  }

  /**
   * setter for named required property "portProtocolAcronym".
   * @param portProtocolAcronym value for required property "portProtocolAcronym".
   */
  default void setPortProtocolAcronym(Map<String, String> portProtocolAcronym) {
    getViewedVertex().getProperties().put("portProtocolAcronym", VertexProperty.create(portProtocolAcronym));
  }

  /**
   * getter for required property "portIsInitiator".
   * @return "portIsInitiator".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Map<String, Boolean> getPortIsInitiator() {
    return getViewedVertex().getProperties().containsKey("portIsInitiator") ?
                    (Map<String, Boolean>) getViewedVertex().getProperties().get("portIsInitiator").unwrap() :
                    null;
  }

  /**
   * setter for named required property "portIsInitiator".
   * @param portIsInitiator value for required property "portIsInitiator".
   */
  default void setPortIsInitiator(Map<String, Boolean> portIsInitiator) {
    getViewedVertex().getProperties().put("portIsInitiator", VertexProperty.create(portIsInitiator));
  }

  /**
   * getter for required property "portWidthInBits".
   * @return "portWidthInBits".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Map<String, Integer> getPortWidthInBits() {
    return getViewedVertex().getProperties().containsKey("portWidthInBits") ?
                    (Map<String, Integer>) getViewedVertex().getProperties().get("portWidthInBits").unwrap() :
                    null;
  }

  /**
   * setter for named required property "portWidthInBits".
   * @param portWidthInBits value for required property "portWidthInBits".
   */
  default void setPortWidthInBits(Map<String, Integer> portWidthInBits) {
    getViewedVertex().getProperties().put("portWidthInBits", VertexProperty.create(portWidthInBits));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_SYNTHETIZABLEDIGITALPORTS)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_SYNTHETIZABLEDIGITALPORTS)) return true;
    }
    return false;
  }

  static Optional<SynthetizableDigitalPorts> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new SynthetizableDigitalPortsViewer(vertex)) : Optional.empty();
  }

  static Optional<SynthetizableDigitalPorts> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new SynthetizableDigitalPortsViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static SynthetizableDigitalPorts enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_SYNTHETIZABLEDIGITALPORTS);
    vertex.ports.addAll(SynthetizableDigitalPorts.getRequiredPorts());
    for(String key : SynthetizableDigitalPorts.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, SynthetizableDigitalPorts.getRequiredProperties().get(key));
    }
    return new SynthetizableDigitalPortsViewer(vertex);
  }

  static SynthetizableDigitalPorts enforce(VertexViewer viewer) {
    return SynthetizableDigitalPorts.enforce(viewer.getViewedVertex());
  }
}
