package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface AbstractScheduler extends VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_RUNTIME_ABSTRACTSCHEDULER)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_RUNTIME_ABSTRACTSCHEDULER)) return true;
    }
    return false;
  }

  static Optional<AbstractScheduler> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new AbstractSchedulerViewer(vertex)) : Optional.empty();
  }

  static Optional<AbstractScheduler> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new AbstractSchedulerViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static AbstractScheduler enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_RUNTIME_ABSTRACTSCHEDULER);
    vertex.ports.addAll(AbstractScheduler.getRequiredPorts());
    for(String key : AbstractScheduler.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, AbstractScheduler.getRequiredProperties().get(key));
    }
    return new AbstractSchedulerViewer(vertex);
  }

  static AbstractScheduler enforce(VertexViewer viewer) {
    return AbstractScheduler.enforce(viewer.getViewedVertex());
  }
}
