package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class AbstractSchedulerViewer implements AbstractScheduler {
  public final Vertex viewedVertex;

  public AbstractSchedulerViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "AbstractScheduler".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof AbstractSchedulerViewer ? ((AbstractSchedulerViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "AbstractSchedulerViewer{" + getViewedVertex().toString() + "}";
  }
}
