package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface FixedPriorityScheduler extends AbstractScheduler, VertexViewer {
  /**
   * getter for required property "preemptive".
   * @return "preemptive".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Boolean getPreemptive() {
    return getViewedVertex().getProperties().containsKey("preemptive") ?
                    (Boolean) getViewedVertex().getProperties().get("preemptive").unwrap() :
                    null;
  }

  /**
   * setter for named required property "preemptive".
   * @param preemptive value for required property "preemptive".
   */
  default void setPreemptive(Boolean preemptive) {
    getViewedVertex().getProperties().put("preemptive", VertexProperty.create(preemptive));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER)) return true;
    }
    return false;
  }

  static Optional<FixedPriorityScheduler> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new FixedPrioritySchedulerViewer(vertex)) : Optional.empty();
  }

  static Optional<FixedPriorityScheduler> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new FixedPrioritySchedulerViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static FixedPriorityScheduler enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_RUNTIME_FIXEDPRIORITYSCHEDULER);
    vertex.ports.addAll(FixedPriorityScheduler.getRequiredPorts());
    for(String key : FixedPriorityScheduler.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, FixedPriorityScheduler.getRequiredProperties().get(key));
    }
    return new FixedPrioritySchedulerViewer(vertex);
  }

  static FixedPriorityScheduler enforce(VertexViewer viewer) {
    return FixedPriorityScheduler.enforce(viewer.getViewedVertex());
  }
}
