package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface RoundRobinScheduler extends AbstractScheduler, VertexViewer {
  /**
   * getter for required property "maximumTimeSliceInCycles".
   * @return "maximumTimeSliceInCycles".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getMaximumTimeSliceInCycles() {
    return getViewedVertex().getProperties().containsKey("maximumTimeSliceInCycles") ?
                    (Long) getViewedVertex().getProperties().get("maximumTimeSliceInCycles").unwrap() :
                    null;
  }

  /**
   * setter for named required property "maximumTimeSliceInCycles".
   * @param maximumTimeSliceInCycles value for required property "maximumTimeSliceInCycles".
   */
  default void setMaximumTimeSliceInCycles(Long maximumTimeSliceInCycles) {
    getViewedVertex().getProperties().put("maximumTimeSliceInCycles", VertexProperty.create(maximumTimeSliceInCycles));
  }

  /**
   * getter for required property "minimumTimeSliceInCycles".
   * @return "minimumTimeSliceInCycles".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Long getMinimumTimeSliceInCycles() {
    return getViewedVertex().getProperties().containsKey("minimumTimeSliceInCycles") ?
                    (Long) getViewedVertex().getProperties().get("minimumTimeSliceInCycles").unwrap() :
                    null;
  }

  /**
   * setter for named required property "minimumTimeSliceInCycles".
   * @param minimumTimeSliceInCycles value for required property "minimumTimeSliceInCycles".
   */
  default void setMinimumTimeSliceInCycles(Long minimumTimeSliceInCycles) {
    getViewedVertex().getProperties().put("minimumTimeSliceInCycles", VertexProperty.create(minimumTimeSliceInCycles));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_RUNTIME_ROUNDROBINSCHEDULER)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_RUNTIME_ROUNDROBINSCHEDULER)) return true;
    }
    return false;
  }

  static Optional<RoundRobinScheduler> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new RoundRobinSchedulerViewer(vertex)) : Optional.empty();
  }

  static Optional<RoundRobinScheduler> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new RoundRobinSchedulerViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static RoundRobinScheduler enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_RUNTIME_ROUNDROBINSCHEDULER);
    vertex.ports.addAll(RoundRobinScheduler.getRequiredPorts());
    for(String key : RoundRobinScheduler.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, RoundRobinScheduler.getRequiredProperties().get(key));
    }
    return new RoundRobinSchedulerViewer(vertex);
  }

  static RoundRobinScheduler enforce(VertexViewer viewer) {
    return RoundRobinScheduler.enforce(viewer.getViewedVertex());
  }
}
