package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class RoundRobinSchedulerViewer implements RoundRobinScheduler {
  public final Vertex viewedVertex;

  public RoundRobinSchedulerViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "RoundRobinScheduler".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof RoundRobinSchedulerViewer ? ((RoundRobinSchedulerViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "RoundRobinSchedulerViewer{" + getViewedVertex().toString() + "}";
  }
}
