package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface StaticCyclicScheduler extends AbstractScheduler, VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_RUNTIME_STATICCYCLICSCHEDULER)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_RUNTIME_STATICCYCLICSCHEDULER)) return true;
    }
    return false;
  }

  static Optional<StaticCyclicScheduler> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new StaticCyclicSchedulerViewer(vertex)) : Optional.empty();
  }

  static Optional<StaticCyclicScheduler> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new StaticCyclicSchedulerViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static StaticCyclicScheduler enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_RUNTIME_STATICCYCLICSCHEDULER);
    vertex.ports.addAll(StaticCyclicScheduler.getRequiredPorts());
    for(String key : StaticCyclicScheduler.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, StaticCyclicScheduler.getRequiredProperties().get(key));
    }
    return new StaticCyclicSchedulerViewer(vertex);
  }

  static StaticCyclicScheduler enforce(VertexViewer viewer) {
    return StaticCyclicScheduler.enforce(viewer.getViewedVertex());
  }
}
