package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class StaticCyclicSchedulerViewer implements StaticCyclicScheduler {
  public final Vertex viewedVertex;

  public StaticCyclicSchedulerViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "StaticCyclicScheduler".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof StaticCyclicSchedulerViewer ? ((StaticCyclicSchedulerViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "StaticCyclicSchedulerViewer{" + getViewedVertex().toString() + "}";
  }
}
