package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface TimeTriggeredScheduler extends AbstractScheduler, VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_RUNTIME_TIMETRIGGEREDSCHEDULER)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.PLATFORM_RUNTIME_TIMETRIGGEREDSCHEDULER)) return true;
    }
    return false;
  }

  static Optional<TimeTriggeredScheduler> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new TimeTriggeredSchedulerViewer(vertex)) : Optional.empty();
  }

  static Optional<TimeTriggeredScheduler> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new TimeTriggeredSchedulerViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static TimeTriggeredScheduler enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.PLATFORM_RUNTIME_TIMETRIGGEREDSCHEDULER);
    vertex.ports.addAll(TimeTriggeredScheduler.getRequiredPorts());
    for(String key : TimeTriggeredScheduler.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, TimeTriggeredScheduler.getRequiredProperties().get(key));
    }
    return new TimeTriggeredSchedulerViewer(vertex);
  }

  static TimeTriggeredScheduler enforce(VertexViewer viewer) {
    return TimeTriggeredScheduler.enforce(viewer.getViewedVertex());
  }
}
