package forsyde.io.java.typed.viewers.platform.runtime;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class TimeTriggeredSchedulerViewer implements TimeTriggeredScheduler {
  public final Vertex viewedVertex;

  public TimeTriggeredSchedulerViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "TimeTriggeredScheduler".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof TimeTriggeredSchedulerViewer ? ((TimeTriggeredSchedulerViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "TimeTriggeredSchedulerViewer{" + getViewedVertex().toString() + "}";
  }
}
