package forsyde.io.java.typed.viewers.visualization;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class GreyBoxViewer implements GreyBox {
  public final Vertex viewedVertex;

  public GreyBoxViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "GreyBox".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof GreyBoxViewer ? ((GreyBoxViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "GreyBoxViewer{" + getViewedVertex().toString() + "}";
  }
}
