package forsyde.io.java.typed.viewers.visualization;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Positioned extends Visualizable, VertexViewer {
  /**
   * getter for required property "positionX".
   * @return "positionX".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Integer getPositionX() {
    return getViewedVertex().getProperties().containsKey("positionX") ?
                    (Integer) getViewedVertex().getProperties().get("positionX").unwrap() :
                    null;
  }

  /**
   * setter for named required property "positionX".
   * @param positionX value for required property "positionX".
   */
  default void setPositionX(Integer positionX) {
    getViewedVertex().getProperties().put("positionX", VertexProperty.create(positionX));
  }

  /**
   * getter for required property "positionY".
   * @return "positionY".
   * " property
   */
  @SuppressWarnings("unchecked")
  default Integer getPositionY() {
    return getViewedVertex().getProperties().containsKey("positionY") ?
                    (Integer) getViewedVertex().getProperties().get("positionY").unwrap() :
                    null;
  }

  /**
   * setter for named required property "positionY".
   * @param positionY value for required property "positionY".
   */
  default void setPositionY(Integer positionY) {
    getViewedVertex().getProperties().put("positionY", VertexProperty.create(positionY));
  }

  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.VISUALIZATION_POSITIONED)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.VISUALIZATION_POSITIONED)) return true;
    }
    return false;
  }

  static Optional<Positioned> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new PositionedViewer(vertex)) : Optional.empty();
  }

  static Optional<Positioned> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new PositionedViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static Positioned enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.VISUALIZATION_POSITIONED);
    vertex.ports.addAll(Positioned.getRequiredPorts());
    for(String key : Positioned.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, Positioned.getRequiredProperties().get(key));
    }
    return new PositionedViewer(vertex);
  }

  static Positioned enforce(VertexViewer viewer) {
    return Positioned.enforce(viewer.getViewedVertex());
  }
}
