package forsyde.io.java.typed.viewers.visualization;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class PositionedViewer implements Positioned {
  public final Vertex viewedVertex;

  public PositionedViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "Positioned".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof PositionedViewer ? ((PositionedViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "PositionedViewer{" + getViewedVertex().toString() + "}";
  }
}
