package forsyde.io.java.typed.viewers.visualization;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import java.lang.Boolean;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Visualizable extends VertexViewer {
  static Boolean conforms(Vertex vertex) {
    for (Trait t : vertex.getTraits()) {
      if(t.refines(VertexTrait.VISUALIZATION_VISUALIZABLE)) return true;
    }
    return false;
  }

  static Boolean conforms(VertexViewer viewer) {
    for (Trait t : viewer.getViewedVertex().getTraits()) {
      if(t.refines(VertexTrait.VISUALIZATION_VISUALIZABLE)) return true;
    }
    return false;
  }

  static Optional<Visualizable> safeCast(Vertex vertex) {
    return conforms(vertex) ? Optional.of(new VisualizableViewer(vertex)) : Optional.empty();
  }

  static Optional<Visualizable> safeCast(VertexViewer viewer) {
    return conforms(viewer.getViewedVertex()) ? Optional.of(new VisualizableViewer(viewer.getViewedVertex())) : Optional.empty();
  }

  static Set<String> getRequiredPorts() {
    return Set.of();
  }

  static Map<String, VertexProperty> getRequiredProperties() {
    return Map.of();
  }

  static Visualizable enforce(Vertex vertex) {
    vertex.addTraits(VertexTrait.VISUALIZATION_VISUALIZABLE);
    vertex.ports.addAll(Visualizable.getRequiredPorts());
    for(String key : Visualizable.getRequiredProperties().keySet()) {
      vertex.properties.putIfAbsent(key, Visualizable.getRequiredProperties().get(key));
    }
    return new VisualizableViewer(vertex);
  }

  static Visualizable enforce(VertexViewer viewer) {
    return Visualizable.enforce(viewer.getViewedVertex());
  }
}
