package forsyde.io.java.typed.viewers.visualization;

import forsyde.io.java.core.Vertex;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;

public final class VisualizableViewer implements Visualizable {
  public final Vertex viewedVertex;

  public VisualizableViewer(Vertex vertex) {
    viewedVertex = vertex;
  }

  public Vertex getViewedVertex() {
    return viewedVertex;
  }

  @Override
  public int hashCode() {
    return getIdentifier().hashCode() + "Visualizable".hashCode();
  }

  @Override
  public boolean equals(Object other) {
    return other instanceof VisualizableViewer ? ((VisualizableViewer) other).getIdentifier().equals(getIdentifier()) : false;
  }

  @Override
  public String toString() {
    return "VisualizableViewer{" + getViewedVertex().toString() + "}";
  }
}
