/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.core;

import forsyde.io.java.core.EdgeTrait;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Deprecated
public final class Edge {
    public Vertex source;
    public Vertex target;
    public Optional<String> sourcePort;
    public Optional<String> targetPort;
    public Set<Trait> edgeTraits = new HashSet<Trait>();

    public Edge(Vertex source, Vertex target) {
        this.target = target;
        this.source = source;
        this.sourcePort = Optional.empty();
        this.targetPort = Optional.empty();
    }

    public Edge(Vertex source, Vertex target, String sourcePort, String targetPort) {
        this.target = target;
        this.source = source;
        this.targetPort = targetPort == null ? Optional.empty() : Optional.of(targetPort);
        this.sourcePort = sourcePort == null ? Optional.empty() : Optional.of(sourcePort);
    }

    public Edge(Vertex source, Vertex target, Optional<String> sourcePort, Optional<String> targetPort) {
        this.target = target;
        this.source = source;
        this.targetPort = targetPort;
        this.sourcePort = sourcePort;
    }

    public Set<Trait> getTraits() {
        return this.edgeTraits;
    }

    public boolean hasTrait(EdgeTrait trait) {
        return this.edgeTraits.stream().anyMatch(t -> t.refines(trait));
    }

    public int hashCode() {
        return Objects.hash(this.target, this.targetPort, this.source, this.sourcePort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)obj;
        return Objects.equals(this.target, other.target) && Objects.equals(this.targetPort, other.targetPort) && Objects.equals(this.source, other.source) && Objects.equals(this.sourcePort, other.sourcePort);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Edge [traits=").append(this.edgeTraits).append(", source=").append(this.source).append(", target=").append(this.target).append(", sourcePort=").append(this.sourcePort).append(", targetPort=").append(this.targetPort).append("]");
        return builder.toString();
    }

    public String toIDString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.source.getIdentifier());
        this.sourcePort.ifPresent(s -> builder.append(".").append((String)s));
        builder.append("[").append(this.edgeTraits.stream().map(Trait::getName).collect(Collectors.joining(";"))).append("]");
        this.targetPort.ifPresent(s -> builder.append(".").append((String)s));
        builder.append(this.target.getIdentifier());
        return builder.toString();
    }

    public String toCppCompileableIDString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.source.getIdentifier());
        this.sourcePort.ifPresent(s -> builder.append("_").append((String)s));
        builder.append("_to_");
        this.targetPort.ifPresent(s -> builder.append("_").append((String)s));
        builder.append(this.target.getIdentifier());
        builder.append("_with_").append(this.edgeTraits.stream().map(Trait::getName).collect(Collectors.joining("_")));
        return builder.toString();
    }

    public Vertex getSource() {
        return this.source;
    }

    public Vertex getTarget() {
        return this.target;
    }

    public Optional<String> getSourcePort() {
        return this.sourcePort;
    }

    public Optional<String> getTargetPort() {
        return this.targetPort;
    }

    public void addTraits(Trait ... traits) {
        this.edgeTraits.addAll(Arrays.asList((Trait[])traits.clone()));
    }
}

