/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.core;

import forsyde.io.java.core.EdgeTrait;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class EdgeInfo {
    public String sourceId;
    public String targetId;
    public Optional<String> sourcePort;
    public Optional<String> targetPort;
    public Set<Trait> edgeTraits = new HashSet<Trait>();

    public EdgeInfo(Vertex source, Vertex target) {
        this.targetId = target.getIdentifier();
        this.sourceId = source.getIdentifier();
        this.sourcePort = Optional.empty();
        this.targetPort = Optional.empty();
    }

    public EdgeInfo(String sourceId, String targetId) {
        this.targetId = targetId;
        this.sourceId = sourceId;
        this.sourcePort = Optional.empty();
        this.targetPort = Optional.empty();
    }

    public EdgeInfo(String sourceId, String targetId, String sourcePort, String targetPort) {
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.targetPort = targetPort == null ? Optional.empty() : Optional.ofNullable(targetPort);
        this.sourcePort = sourcePort == null ? Optional.empty() : Optional.ofNullable(sourcePort);
    }

    public EdgeInfo(String sourceId, String targetId, Optional<String> sourcePort, Optional<String> targetPort) {
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.sourcePort = sourcePort;
        this.targetPort = targetPort;
    }

    public Set<Trait> getTraits() {
        return this.edgeTraits;
    }

    public boolean hasTrait(EdgeTrait trait) {
        return this.edgeTraits.stream().anyMatch(t -> t.refines(trait));
    }

    public int hashCode() {
        return Objects.hash(this.targetId, this.targetPort, this.sourceId, this.sourcePort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EdgeInfo)) {
            return false;
        }
        EdgeInfo other = (EdgeInfo)obj;
        return Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetPort, other.targetPort) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.sourcePort, other.sourcePort);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Edge [traits=").append(this.edgeTraits).append(", source=").append(this.sourceId).append(", target=").append(this.targetId).append(", sourcePort=").append(this.sourcePort).append(", targetPort=").append(this.targetPort).append("]");
        return builder.toString();
    }

    public String toIDString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.sourceId);
        this.sourcePort.ifPresent(s -> builder.append(".").append((String)s));
        builder.append("[").append(this.edgeTraits.stream().map(Trait::getName).collect(Collectors.joining(";"))).append("]");
        this.targetPort.ifPresent(s -> builder.append(".").append((String)s));
        builder.append(this.targetId);
        return builder.toString();
    }

    public String getSource() {
        return this.sourceId;
    }

    public String getTarget() {
        return this.targetId;
    }

    public Optional<String> getSourcePort() {
        return this.sourcePort;
    }

    public Optional<String> getTargetPort() {
        return this.targetPort;
    }

    public void addTraits(Trait ... traits) {
        this.edgeTraits.addAll(Arrays.asList((Trait[])traits.clone()));
    }
}

