/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.core;

import forsyde.io.java.core.EdgeInfo;
import forsyde.io.java.core.EdgeTrait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexViewer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.graph.DirectedPseudograph;

public class ForSyDeSystemGraph
extends DirectedPseudograph<Vertex, EdgeInfo> {
    public ForSyDeSystemGraph() {
        super(EdgeInfo.class);
    }

    public boolean mergeInPlace(ForSyDeSystemGraph other) {
        boolean present;
        boolean mergeDefined = true;
        for (Vertex v2 : other.vertexSet()) {
            present = false;
            for (Vertex thisV : this.vertexSet()) {
                if (!Objects.equals(v2.getIdentifier(), thisV.getIdentifier())) continue;
                mergeDefined = mergeDefined && thisV.mergeInPlace(v2);
                present = true;
                break;
            }
            if (present) continue;
            this.addVertex(v2);
        }
        for (EdgeInfo e : other.edgeSet()) {
            present = false;
            for (EdgeInfo thisE : this.edgeSet()) {
                if (!e.equals(thisE)) continue;
                thisE.getTraits().addAll(e.getTraits());
                present = true;
            }
            if (present) continue;
            Vertex source = this.vertexSet().stream().filter(v -> v.getIdentifier().equals(e.getSource())).findAny().get();
            Vertex target = this.vertexSet().stream().filter(v -> v.getIdentifier().equals(e.getTarget())).findAny().get();
            this.addEdge(source, target, e);
        }
        return mergeDefined;
    }

    public ForSyDeSystemGraph merge(ForSyDeSystemGraph other) {
        ForSyDeSystemGraph merged = new ForSyDeSystemGraph();
        merged.mergeInPlace(this);
        merged.mergeInPlace(other);
        return merged;
    }

    public boolean connect(Vertex src, Vertex dst, EdgeTrait ... traits) {
        EdgeInfo e = new EdgeInfo(src.getIdentifier(), dst.getIdentifier());
        e.edgeTraits.addAll(Arrays.asList((EdgeTrait[])traits.clone()));
        return this.addEdge(src, dst, e);
    }

    public boolean connect(VertexViewer src, VertexViewer dst, EdgeTrait ... traits) {
        return this.connect(src.getViewedVertex(), dst.getViewedVertex(), traits);
    }

    public boolean connect(Vertex src, Vertex dst, String portSrc, EdgeTrait ... traits) {
        if (portSrc != null && !portSrc.isEmpty() && src.ports.contains(portSrc)) {
            Set<EdgeInfo> present = this.getAllEdges(src, dst).stream().filter(edgeInfo -> edgeInfo.getSourcePort().equals(Optional.of(portSrc))).collect(Collectors.toSet());
            if (present.isEmpty()) {
                EdgeInfo e2 = new EdgeInfo(src.getIdentifier(), dst.getIdentifier(), portSrc != null && !portSrc.isEmpty() ? Optional.of(portSrc) : Optional.empty(), Optional.empty());
                e2.edgeTraits.addAll(Arrays.asList((EdgeTrait[])traits.clone()));
                return this.addEdge(src, dst, e2);
            }
            present.forEach(e -> e.edgeTraits.addAll(Arrays.asList((EdgeTrait[])traits.clone())));
            return true;
        }
        return false;
    }

    public boolean connect(VertexViewer src, VertexViewer dst, String portSrc, EdgeTrait ... traits) {
        return this.connect(src.getViewedVertex(), dst.getViewedVertex(), portSrc, traits);
    }

    public boolean connect(Vertex src, Vertex dst, String portSrc, String portDst, EdgeTrait ... traits) {
        if (portDst != null && !portDst.isEmpty() && dst.ports.contains(portDst) && (portSrc == null || portSrc.isEmpty() || src.ports.contains(portSrc))) {
            Set<EdgeInfo> present = this.getAllEdges(src, dst).stream().filter(edgeInfo -> edgeInfo.getSourcePort().equals(Optional.ofNullable(portSrc)) && edgeInfo.getTargetPort().equals(Optional.of(portDst))).collect(Collectors.toSet());
            if (present.isEmpty()) {
                EdgeInfo e2 = new EdgeInfo(src.getIdentifier(), dst.getIdentifier(), portSrc != null && !portSrc.isEmpty() ? Optional.of(portSrc) : Optional.empty(), Optional.of(portDst));
                e2.edgeTraits.addAll(Arrays.asList((EdgeTrait[])traits.clone()));
                return this.addEdge(src, dst, e2);
            }
            present.forEach(e -> e.edgeTraits.addAll(Arrays.asList((EdgeTrait[])traits.clone())));
            return true;
        }
        return false;
    }

    public boolean connect(VertexViewer src, VertexViewer dst, String portSrc, String portDst, EdgeTrait ... traits) {
        return this.connect(src.getViewedVertex(), dst.getViewedVertex(), portSrc, portDst, traits);
    }

    public boolean hasConnection(VertexViewer src, VertexViewer dst) {
        return this.containsEdge(src.getViewedVertex(), dst.getViewedVertex());
    }

    public boolean hasConnection(VertexViewer src, VertexViewer dst, EdgeTrait ... traits) {
        Set edgeInfoSet = this.getAllEdges(src.getViewedVertex(), dst.getViewedVertex());
        for (EdgeTrait trait : traits) {
            if (!edgeInfoSet.stream().noneMatch(e -> e.hasTrait(trait))) continue;
            return false;
        }
        return true;
    }

    public boolean hasConnection(VertexViewer src, VertexViewer dst, String srcPort, String dstPort) {
        Set edges = this.getAllEdges(src.getViewedVertex(), dst.getViewedVertex());
        Boolean isConnected = edges.size() > 0;
        if (isConnected.booleanValue() && srcPort != null && !srcPort.isEmpty()) {
            isConnected = isConnected != false && edges.stream().filter(e -> e.sourcePort.isPresent()).flatMap(e -> e.sourcePort.stream()).anyMatch(p -> p.equals(srcPort));
        }
        if (isConnected.booleanValue() && dstPort != null && !dstPort.isEmpty()) {
            isConnected = isConnected != false && edges.stream().filter(e -> e.targetPort.isPresent()).flatMap(e -> e.targetPort.stream()).anyMatch(p -> p.equals(dstPort));
        }
        return isConnected;
    }

    public Optional<Vertex> queryVertex(String vertexId) {
        return this.vertexSet().stream().filter(v -> v.identifier.equals(vertexId)).findAny();
    }
}

