/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.core;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class Vertex {
    private static volatile long genSymSuffix = 0L;
    public String identifier;
    public Set<String> ports = new HashSet<String>();
    public Map<String, VertexProperty> properties = new HashMap<String, VertexProperty>();
    public Set<Trait> vertexTraits = new HashSet<Trait>();

    public Vertex() {
        this.identifier = "v" + String.valueOf(++genSymSuffix);
    }

    public Vertex(String identifier) {
        this.identifier = identifier;
    }

    public Vertex(String identifier, Trait ... traits) {
        this.identifier = identifier;
        this.addTraits(traits);
    }

    public Vertex(String identifier, Set<String> ports, Map<String, VertexProperty> properties) {
        this.identifier = identifier;
        this.ports = ports;
        this.properties = properties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append(this.identifier);
        sb.append("[").append(this.vertexTraits.stream().map(Trait::getName).collect(Collectors.joining("; "))).append("]");
        sb.append("(").append(String.join((CharSequence)", ", this.ports)).append(")");
        sb.append("{").append(this.properties.entrySet().stream().map(e -> (String)e.getKey() + ": " + ((VertexProperty)e.getValue()).toString()).collect(Collectors.joining(", "))).append("}");
        return sb.toString();
    }

    public Set<Trait> getTraits() {
        return this.vertexTraits;
    }

    public Boolean hasTrait(Trait trait) {
        return this.vertexTraits.stream().anyMatch(t -> t.refines(trait));
    }

    public Boolean hasTrait(String traitName) {
        try {
            VertexTrait trait = VertexTrait.valueOf(traitName);
            return this.hasTrait(trait);
        }
        catch (IllegalArgumentException e) {
            return this.vertexTraits.stream().map(t -> t.getName()).anyMatch(t -> t.equals(traitName));
        }
    }

    public boolean putProperty(String propertyName, Object propertyValue) {
        return this.properties.put(propertyName, VertexProperty.create(propertyValue)) == null;
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vertex)) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return Objects.equals(this.identifier, other.identifier);
    }

    public boolean mergeInPlace(Vertex other) {
        boolean mergeDefined = true;
        if (!Objects.equals(this.identifier, other.getIdentifier())) {
            return false;
        }
        this.ports.addAll(other.getPorts());
        this.vertexTraits.addAll(other.getTraits());
        for (String key : other.getProperties().keySet()) {
            if (this.properties.containsKey(key)) {
                mergeDefined = mergeDefined && this.properties.get(key).mergeInPlace(other.getProperties().get(key));
                continue;
            }
            this.properties.put(key, other.getProperties().get(key));
        }
        return mergeDefined;
    }

    public Optional<Vertex> merge(Vertex other) {
        if (this.identifier != other.getIdentifier()) {
            return Optional.empty();
        }
        Vertex merged = new Vertex(this.identifier);
        if (merged.mergeInPlace(this) && merged.mergeInPlace(other)) {
            return Optional.of(merged);
        }
        return Optional.empty();
    }

    public Map<String, VertexProperty> getProperties() {
        return this.properties;
    }

    public Set<String> getPorts() {
        return this.ports;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void addTraits(Trait ... traits) {
        this.vertexTraits.addAll(Arrays.asList((Trait[])traits.clone()));
    }
}

