/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.core;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.OpaqueTrait;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexTrait;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class VertexAcessor {
    public static Optional<Vertex> getNamedPort(ForSyDeSystemGraph model, Vertex v, String portName, String traitName) {
        return VertexAcessor.getNamedPort(model, v, portName, traitName, "BIDIRECTIONAL");
    }

    public static Optional<Vertex> getNamedPort(ForSyDeSystemGraph model, Vertex v, String portName, String traitName, String direction) {
        Trait t = VertexAcessor.traitFromString(traitName);
        if (direction.equalsIgnoreCase("outgoing") || direction.equalsIgnoreCase("bidirectional")) {
            Set outEdges = model.outgoingEdgesOf(v);
            Optional<Vertex> dst = outEdges.stream().filter(e -> e.sourcePort.map(p -> p.equals(portName)).orElse(false)).map(arg_0 -> ((ForSyDeSystemGraph)model).getEdgeTarget(arg_0)).filter(vv -> vv.hasTrait(t)).findAny();
            return dst;
        }
        if (direction.equalsIgnoreCase("incoming") || direction.equalsIgnoreCase("bidirectional")) {
            Set inEdges = model.incomingEdgesOf(v);
            Optional<Vertex> src = inEdges.stream().filter(e -> e.targetPort.map(p -> p.equals(portName)).orElse(false)).map(arg_0 -> ((ForSyDeSystemGraph)model).getEdgeSource(arg_0)).filter(vv -> vv.hasTrait(t)).findAny();
            if (src.isPresent()) {
                return src;
            }
        }
        return Optional.empty();
    }

    public static Optional<Vertex> getNamedPort(ForSyDeSystemGraph model, Vertex v, String portName, Trait trait, String direction) {
        if (direction.equalsIgnoreCase("outgoing") || direction.equalsIgnoreCase("bidirectional")) {
            Set outEdges = model.outgoingEdgesOf(v);
            Optional<Vertex> dst = outEdges.stream().filter(e -> e.sourcePort.map(p -> p.equals(portName)).orElse(false)).map(arg_0 -> ((ForSyDeSystemGraph)model).getEdgeTarget(arg_0)).filter(vv -> vv.hasTrait(trait)).findAny();
            return dst;
        }
        if (direction.equalsIgnoreCase("incoming") || direction.equalsIgnoreCase("bidirectional")) {
            Set inEdges = model.incomingEdgesOf(v);
            Optional<Vertex> src = inEdges.stream().filter(e -> e.targetPort.map(p -> p.equals(portName)).orElse(false)).map(arg_0 -> ((ForSyDeSystemGraph)model).getEdgeSource(arg_0)).filter(vv -> vv.hasTrait(trait)).findAny();
            if (src.isPresent()) {
                return src;
            }
        }
        return Optional.empty();
    }

    public static Set<Vertex> getMultipleNamedPort(ForSyDeSystemGraph model, Vertex v, String portName, String traitName) {
        return VertexAcessor.getMultipleNamedPort(model, v, portName, traitName, "BIDIRECTIONAL");
    }

    public static Set<Vertex> getMultipleNamedPort(ForSyDeSystemGraph model, Vertex v, String portName, String traitName, String direction) {
        HashSet<Vertex> vs = new HashSet<Vertex>();
        Trait t = VertexAcessor.traitFromString(traitName);
        if (direction.equalsIgnoreCase("outgoing") || direction.equalsIgnoreCase("bidirectional")) {
            Set outEdges = model.outgoingEdgesOf(v);
            vs.addAll(outEdges.stream().filter(e -> e.sourcePort.map(p -> p.equals(portName)).orElse(false)).map(arg_0 -> ((ForSyDeSystemGraph)model).getEdgeTarget(arg_0)).filter(vv -> vv.hasTrait(t)).collect(Collectors.toSet()));
        }
        if (direction.equalsIgnoreCase("incoming") || direction.equalsIgnoreCase("bidirectional")) {
            Set inEdges = model.incomingEdgesOf(v);
            vs.addAll(inEdges.stream().filter(e -> e.targetPort.map(p -> p.equals(portName)).orElse(false)).map(arg_0 -> ((ForSyDeSystemGraph)model).getEdgeSource(arg_0)).filter(vv -> vv.hasTrait(t)).collect(Collectors.toSet()));
        }
        return vs;
    }

    public static Set<Vertex> getMultipleNamedPort(ForSyDeSystemGraph model, Vertex v, String portName, Trait trait, String direction) {
        HashSet<Vertex> vs = new HashSet<Vertex>();
        if (direction.equalsIgnoreCase("outgoing") || direction.equalsIgnoreCase("bidirectional")) {
            Set outEdges = model.outgoingEdgesOf(v);
            vs.addAll(outEdges.stream().filter(e -> e.sourcePort.map(p -> p.equals(portName)).orElse(false)).map(arg_0 -> ((ForSyDeSystemGraph)model).getEdgeTarget(arg_0)).filter(vv -> vv.hasTrait(trait)).collect(Collectors.toSet()));
        }
        if (direction.equalsIgnoreCase("incoming") || direction.equalsIgnoreCase("bidirectional")) {
            Set inEdges = model.incomingEdgesOf(v);
            vs.addAll(inEdges.stream().filter(e -> e.targetPort.map(p -> p.equals(portName)).orElse(false)).map(arg_0 -> ((ForSyDeSystemGraph)model).getEdgeSource(arg_0)).filter(vv -> vv.hasTrait(trait)).collect(Collectors.toSet()));
        }
        return vs;
    }

    public static List<Vertex> getOrderedMultipleNamedPort(ForSyDeSystemGraph model, Vertex v, String portName, String traitName) {
        return VertexAcessor.getOrderedMultipleNamedPort(model, v, portName, traitName, "BIDIRECTIONAL");
    }

    public static List<Vertex> getOrderedMultipleNamedPort(ForSyDeSystemGraph model, Vertex v, String portName, String traitName, String direction) {
        Trait t = VertexAcessor.traitFromString(traitName);
        Map order = (Map)v.getProperties().get("__" + portName + "_ordering__").unwrap();
        ArrayList<Vertex> vs = new ArrayList<Vertex>(order.size());
        if (direction.equalsIgnoreCase("outgoing") || direction.equalsIgnoreCase("bidirectional")) {
            Set outEdges = model.outgoingEdgesOf(v);
            outEdges.stream().filter(e -> e.sourcePort.map(p -> p.equals(portName)).orElse(false)).map(arg_0 -> ((ForSyDeSystemGraph)model).getEdgeTarget(arg_0)).filter(vv -> vv.hasTrait(t)).forEach(dst -> vs.set((Integer)order.get(dst.identifier), (Vertex)dst));
        }
        if (direction.equalsIgnoreCase("incoming") || direction.equalsIgnoreCase("bidirectional")) {
            Set inEdges = model.incomingEdgesOf(v);
            inEdges.stream().filter(e -> e.targetPort.map(p -> p.equals(portName)).orElse(false)).map(arg_0 -> ((ForSyDeSystemGraph)model).getEdgeSource(arg_0)).filter(vv -> vv.hasTrait(t)).forEach(dst -> vs.set((Integer)order.get(dst.identifier), (Vertex)dst));
        }
        return vs;
    }

    private static Trait traitFromString(String traitName) {
        try {
            return VertexTrait.valueOf(traitName);
        }
        catch (IllegalArgumentException e) {
            return new OpaqueTrait(traitName);
        }
    }
}

