/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.core;

import forsyde.io.java.core.VertexProperties;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.derive4j.Data;

@Data
public abstract class VertexProperty {
    public abstract <R> R match(Cases<R> var1);

    public static VertexProperty create(float f) {
        return VertexProperties.FloatVertexProperty(f);
    }

    public static VertexProperty create(double d) {
        return VertexProperties.DoubleVertexProperty(d);
    }

    public static VertexProperty create(long l) {
        return VertexProperties.LongVertexProperty(l);
    }

    public static VertexProperty create(int l) {
        return VertexProperties.IntVertexProperty(l);
    }

    public static VertexProperty create(boolean b) {
        return VertexProperties.BooleanVertexProperty(b);
    }

    public static VertexProperty create(Object obj) {
        if (obj instanceof VertexProperty) {
            return (VertexProperty)obj;
        }
        if (obj instanceof Boolean) {
            return VertexProperties.BooleanVertexProperty((Boolean)obj);
        }
        if (obj instanceof Integer) {
            return VertexProperties.IntVertexProperty((Integer)obj);
        }
        if (obj instanceof Long) {
            return VertexProperties.LongVertexProperty((Long)obj);
        }
        if (obj instanceof Float) {
            return VertexProperties.FloatVertexProperty(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return VertexProperties.DoubleVertexProperty((Double)obj);
        }
        if (obj instanceof List) {
            return VertexProperties.ArrayVertexProperty(((List)obj).stream().map(VertexProperty::create).collect(Collectors.toList()));
        }
        if (obj.getClass().isArray()) {
            return VertexProperties.ArrayVertexProperty(Arrays.stream((Object[])obj).map(VertexProperty::create).collect(Collectors.toList()));
        }
        if (obj instanceof Map) {
            Map srcMap = (Map)obj;
            if (!srcMap.isEmpty() && srcMap.keySet().stream().findAny().get() instanceof Integer) {
                return VertexProperties.IntMapVertexProperty(((Map)obj).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> VertexProperty.create(v.getValue()))));
            }
            return VertexProperties.StringMapVertexProperty(((Map)obj).entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toString(), v -> VertexProperty.create(v.getValue()))));
        }
        return VertexProperties.StringVertexProperty(obj.toString());
    }

    public static Object decreate(VertexProperty prop) {
        return VertexProperties.cases().StringVertexProperty(p -> p).IntVertexProperty(p -> (int)p).BooleanVertexProperty(p -> (boolean)p).FloatVertexProperty(p -> Float.valueOf(p.floatValue())).DoubleVertexProperty(d -> (double)d).LongVertexProperty(p -> (long)p).ArrayVertexProperty(l -> l.stream().map(VertexProperty::unwrap).collect(Collectors.toList())).IntMapVertexProperty(m -> m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((VertexProperty)e.getValue()).unwrap()))).StringMapVertexProperty(m -> m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((VertexProperty)e.getValue()).unwrap()))).apply(prop);
    }

    public Object unwrap() {
        return VertexProperty.decreate(this);
    }

    public static boolean mergeInPlace(VertexProperty main, VertexProperty other) {
        return VertexProperties.cases().StringVertexProperty(s -> VertexProperties.cases().StringVertexProperty(s::equals).otherwise_(false).apply(other)).IntVertexProperty(i -> VertexProperties.cases().IntVertexProperty(i::equals).otherwise_(false).apply(other)).BooleanVertexProperty(b -> VertexProperties.cases().BooleanVertexProperty(b::equals).otherwise_(false).apply(other)).FloatVertexProperty(f -> VertexProperties.cases().FloatVertexProperty(f::equals).otherwise_(false).apply(other)).DoubleVertexProperty(d -> VertexProperties.cases().DoubleVertexProperty(d::equals).otherwise_(false).apply(other)).LongVertexProperty(l -> VertexProperties.cases().LongVertexProperty(l::equals).otherwise_(false).apply(other)).ArrayVertexProperty(a -> VertexProperties.cases().ArrayVertexProperty(aOther -> {
            Iterator<VertexProperty> otherIt = aOther.iterator();
            Iterator thisIt = a.iterator();
            while (otherIt.hasNext() && thisIt.hasNext()) {
                if (((VertexProperty)thisIt.next()).mergeInPlace((VertexProperty)otherIt.next())) continue;
                return false;
            }
            otherIt.forEachRemaining(a::add);
            return true;
        }).otherwise_(false).apply(other)).IntMapVertexProperty(m -> VertexProperties.cases().IntMapVertexProperty(mOther -> {
            for (Integer key : mOther.keySet()) {
                if (m.containsKey(key)) {
                    if (((VertexProperty)m.get(key)).mergeInPlace((VertexProperty)mOther.get(key))) continue;
                    return false;
                }
                m.put(key, (VertexProperty)mOther.get(key));
            }
            return true;
        }).otherwise_(false).apply(other)).StringMapVertexProperty(m -> VertexProperties.cases().StringMapVertexProperty(mOther -> {
            for (String key : mOther.keySet()) {
                if (m.containsKey(key)) {
                    if (((VertexProperty)m.get(key)).mergeInPlace((VertexProperty)mOther.get(key))) continue;
                    return false;
                }
                m.put(key, (VertexProperty)mOther.get(key));
            }
            return true;
        }).otherwise_(false).apply(other)).apply(main);
    }

    public boolean mergeInPlace(VertexProperty other) {
        return VertexProperty.mergeInPlace(this, other);
    }

    static interface Cases<R> {
        public R StringVertexProperty(String var1);

        public R IntVertexProperty(int var1);

        public R BooleanVertexProperty(boolean var1);

        public R FloatVertexProperty(float var1);

        public R DoubleVertexProperty(double var1);

        public R LongVertexProperty(long var1);

        public R ArrayVertexProperty(List<VertexProperty> var1);

        public R IntMapVertexProperty(Map<Integer, VertexProperty> var1);

        public R StringMapVertexProperty(Map<String, VertexProperty> var1);
    }
}

