/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.core;

import forsyde.io.java.core.VertexPropertyType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Deprecated(since="0.3.9")
public class VertexPropertyOld {
    public VertexPropertyType type;
    public boolean b;
    public int i;
    public long l;
    public float f;
    public double d;
    public List<VertexPropertyOld> array = null;
    public Map<String, VertexPropertyOld> stringMap = null;
    public Map<Integer, VertexPropertyOld> intMap = null;
    public String s;

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        switch (this.type) {
            case DOUBLE: {
                sb.append(this.d);
                break;
            }
            case INTEGER: {
                sb.append(this.i);
                break;
            }
            case LONG: {
                sb.append(this.l);
                break;
            }
            case BOOLEAN: {
                sb.append(this.b);
                break;
            }
            case FLOAT: {
                sb.append(this.f);
                break;
            }
            case ARRAY: {
                sb.append("[");
                sb.append(this.array.stream().map(VertexPropertyOld::toString).collect(Collectors.joining(", ")));
                sb.append("]");
                break;
            }
            case INTMAP: {
                sb.append("{");
                sb.append(this.intMap.entrySet().stream().map(e -> ((Integer)e.getKey()).toString() + ": " + ((VertexPropertyOld)e.getValue()).toString()).collect(Collectors.joining(", ")));
                sb.append("}");
                break;
            }
            case STRINGMAP: {
                sb.append("{");
                sb.append(this.stringMap.entrySet().stream().map(e -> (String)e.getKey() + ": " + ((VertexPropertyOld)e.getValue()).toString()).collect(Collectors.joining(", ")));
                sb.append("}");
                break;
            }
            default: {
                sb.append(this.s);
            }
        }
        return sb.toString();
    }

    public static VertexPropertyOld create(Object obj) {
        if (obj instanceof VertexPropertyOld) {
            return (VertexPropertyOld)obj;
        }
        VertexPropertyOld p = new VertexPropertyOld();
        if (obj instanceof Boolean) {
            p.type = VertexPropertyType.BOOLEAN;
            p.b = (Boolean)obj;
            return p;
        }
        if (obj instanceof Integer) {
            p.type = VertexPropertyType.INTEGER;
            p.i = (Integer)obj;
            return p;
        }
        if (obj instanceof Long) {
            p.type = VertexPropertyType.LONG;
            p.l = (Long)obj;
            return p;
        }
        if (obj instanceof Float) {
            p.type = VertexPropertyType.FLOAT;
            p.f = ((Float)obj).floatValue();
            return p;
        }
        if (obj instanceof Double) {
            p.type = VertexPropertyType.DOUBLE;
            p.d = (Double)obj;
            return p;
        }
        if (obj instanceof List) {
            p.type = VertexPropertyType.ARRAY;
            List src = (List)obj;
            p.array = src.stream().map(VertexPropertyOld::create).collect(Collectors.toList());
            return p;
        }
        if (obj.getClass().isArray()) {
            p.type = VertexPropertyType.ARRAY;
            Object[] src = (Object[])obj;
            p.array = new ArrayList<VertexPropertyOld>(src.length);
            for (Object o : src) {
                p.array.add(VertexPropertyOld.create(o));
            }
            return p;
        }
        if (obj instanceof Map) {
            Map srcMap = (Map)obj;
            if (!srcMap.isEmpty() && srcMap.keySet().stream().findAny().get() instanceof Integer) {
                p.type = VertexPropertyType.INTMAP;
                Map src = (Map)obj;
                p.intMap = src.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> VertexPropertyOld.create(v.getValue())));
                return p;
            }
            p.type = VertexPropertyType.STRINGMAP;
            p.stringMap = srcMap.entrySet().stream().collect(Collectors.toMap(k -> k.getKey().toString(), v -> VertexPropertyOld.create(v.getValue())));
            return p;
        }
        p.type = VertexPropertyType.STRING;
        p.s = obj.toString();
        return p;
    }

    public Object unwrap() {
        switch (this.type) {
            case DOUBLE: {
                return this.d;
            }
            case INTEGER: {
                return this.i;
            }
            case LONG: {
                return this.l;
            }
            case BOOLEAN: {
                return this.b;
            }
            case FLOAT: {
                return Float.valueOf(this.f);
            }
            case ARRAY: {
                return this.array.stream().map(VertexPropertyOld::unwrap).collect(Collectors.toList());
            }
            case INTMAP: {
                return this.intMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((VertexPropertyOld)v.getValue()).unwrap()));
            }
            case STRINGMAP: {
                return this.stringMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((VertexPropertyOld)v.getValue()).unwrap()));
            }
        }
        return this.s;
    }

    public boolean mergeInPlace(VertexPropertyOld other) {
        if (this.type == VertexPropertyType.ARRAY && other.type == VertexPropertyType.ARRAY) {
            boolean mergeDefined = true;
            Iterator<VertexPropertyOld> otherIt = other.array.iterator();
            Iterator<VertexPropertyOld> thisIt = this.array.iterator();
            while (mergeDefined && otherIt.hasNext() && thisIt.hasNext()) {
                mergeDefined = mergeDefined && thisIt.next().mergeInPlace(otherIt.next());
            }
            otherIt.forEachRemaining(e -> this.array.add((VertexPropertyOld)e));
            return mergeDefined;
        }
        if (this.type == VertexPropertyType.INTMAP && other.type == VertexPropertyType.INTMAP) {
            boolean mergeDefined = true;
            for (Integer key : other.intMap.keySet()) {
                if (this.intMap.containsKey(key)) {
                    mergeDefined = mergeDefined && this.intMap.get(key).mergeInPlace(other.intMap.get(key));
                    continue;
                }
                this.intMap.put(key, other.intMap.get(key));
            }
            return mergeDefined;
        }
        if (this.type == VertexPropertyType.STRINGMAP && other.type == VertexPropertyType.STRINGMAP) {
            boolean mergeDefined = true;
            for (String key : other.stringMap.keySet()) {
                if (this.stringMap.containsKey(key)) {
                    mergeDefined = mergeDefined && this.stringMap.get(key).mergeInPlace(other.stringMap.get(key));
                    continue;
                }
                this.stringMap.put(key, other.stringMap.get(key));
            }
            return mergeDefined;
        }
        if (this.type == VertexPropertyType.BOOLEAN && other.type == VertexPropertyType.BOOLEAN) {
            return Objects.equals(this.b, other.b);
        }
        if (this.type == VertexPropertyType.INTEGER && other.type == VertexPropertyType.INTEGER) {
            return Objects.equals(this.i, other.i);
        }
        if (this.type == VertexPropertyType.FLOAT && other.type == VertexPropertyType.FLOAT) {
            return Objects.equals(Float.valueOf(this.f), Float.valueOf(other.f));
        }
        if (this.type == VertexPropertyType.DOUBLE && other.type == VertexPropertyType.DOUBLE) {
            return Objects.equals(this.d, other.d);
        }
        if (this.type == VertexPropertyType.STRING && other.type == VertexPropertyType.STRING) {
            return Objects.equals(this.s, other.s);
        }
        if (this.type == VertexPropertyType.LONG && other.type == VertexPropertyType.LONG) {
            return Objects.equals(this.l, other.l);
        }
        return false;
    }
}

