/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.drivers;

import forsyde.io.java.core.ForSyDeSystemGraph;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;

public interface ForSyDeModelDriver {
    public List<String> inputExtensions();

    public List<String> outputExtensions();

    default public ForSyDeSystemGraph loadModel(String filePath) throws Exception {
        return this.loadModel(Paths.get(filePath, new String[0]));
    }

    default public ForSyDeSystemGraph loadModel(File file) throws Exception {
        return this.loadModel(file.toPath());
    }

    default public ForSyDeSystemGraph loadModel(Path inPath) throws Exception {
        return this.loadModel(Files.newInputStream(inPath, new OpenOption[0]));
    }

    public ForSyDeSystemGraph loadModel(InputStream var1) throws Exception;

    default public void writeModel(ForSyDeSystemGraph model, String filePath) throws Exception {
        this.writeModel(model, Paths.get(filePath, new String[0]));
    }

    default public void writeModel(ForSyDeSystemGraph model, File file) throws Exception {
        this.writeModel(model, file.toPath());
    }

    default public void writeModel(ForSyDeSystemGraph model, Path outPath) throws Exception {
        this.writeModel(model, Files.newOutputStream(outPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE));
    }

    public void writeModel(ForSyDeSystemGraph var1, OutputStream var2) throws Exception;
}

