/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.drivers;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.drivers.ForSyDeDOTDriver;
import forsyde.io.java.drivers.ForSyDeGraphMLDriver;
import forsyde.io.java.drivers.ForSyDeMLDriver;
import forsyde.io.java.drivers.ForSyDeModelDriver;
import forsyde.io.java.drivers.ForSyDeXMIDriver;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ForSyDeModelHandler {
    private final List<ForSyDeModelDriver> registeredDrivers = new ArrayList<ForSyDeModelDriver>();
    private final List<PathMatcher> registeredDriversInputMatchers = new ArrayList<PathMatcher>();
    private final List<PathMatcher> registeredDriversOutputMatchers = new ArrayList<PathMatcher>();

    public ForSyDeModelHandler(ForSyDeModelDriver ... extraDrivers) {
        this.registeredDrivers.add(new ForSyDeMLDriver());
        this.registeredDrivers.add(new ForSyDeXMIDriver());
        this.registeredDrivers.add(new ForSyDeDOTDriver());
        this.registeredDrivers.add(new ForSyDeGraphMLDriver());
        this.registeredDrivers.addAll(Arrays.asList(extraDrivers));
        for (ForSyDeModelDriver driver : this.registeredDrivers) {
            String inExtensions = "{" + String.join((CharSequence)",", driver.inputExtensions()) + "}";
            String outExtensions = "{" + String.join((CharSequence)",", driver.outputExtensions()) + "}";
            this.registeredDriversInputMatchers.add(FileSystems.getDefault().getPathMatcher("glob:**." + inExtensions));
            this.registeredDriversOutputMatchers.add(FileSystems.getDefault().getPathMatcher("glob:**." + outExtensions));
        }
    }

    public void registerDriver(ForSyDeModelDriver extraDriver, int loadOrder) {
        if (!this.registeredDrivers.contains(extraDriver)) {
            String inExtensions = "{" + String.join((CharSequence)",", extraDriver.inputExtensions()) + "}";
            String outExtensions = "{" + String.join((CharSequence)",", extraDriver.outputExtensions()) + "}";
            this.registeredDrivers.add(loadOrder, extraDriver);
            this.registeredDriversInputMatchers.add(loadOrder, FileSystems.getDefault().getPathMatcher("glob:**." + inExtensions));
            this.registeredDriversOutputMatchers.add(loadOrder, FileSystems.getDefault().getPathMatcher("glob:**." + outExtensions));
        }
    }

    public void registerDriver(ForSyDeModelDriver extraDriver) {
        this.registerDriver(extraDriver, this.registeredDrivers.size());
    }

    public boolean canLoadModel(Path path) {
        return this.registeredDriversInputMatchers.stream().anyMatch(d -> d.matches(path));
    }

    public boolean canWriteModel(Path path) {
        return this.registeredDriversOutputMatchers.stream().anyMatch(d -> d.matches(path));
    }

    public ForSyDeSystemGraph loadModel(String filePath) throws Exception {
        return this.loadModel(Paths.get(filePath, new String[0]));
    }

    public ForSyDeSystemGraph loadModel(File file) throws Exception {
        return this.loadModel(file.toPath());
    }

    public ForSyDeSystemGraph loadModel(Path inPath) throws Exception {
        for (int i = 0; i < this.registeredDrivers.size(); ++i) {
            if (!this.registeredDriversInputMatchers.get(i).matches(inPath)) continue;
            return this.registeredDrivers.get(i).loadModel(inPath);
        }
        throw new Exception("Unsupported read format for file: " + inPath.toString());
    }

    public void writeModel(ForSyDeSystemGraph model, String filePath) throws Exception {
        this.writeModel(model, Paths.get(filePath, new String[0]));
    }

    public void writeModel(ForSyDeSystemGraph model, File file) throws Exception {
        this.writeModel(model, file.toPath());
    }

    public void writeModel(ForSyDeSystemGraph model, Path outPath) throws Exception {
        for (int i = 0; i < this.registeredDrivers.size(); ++i) {
            if (!this.registeredDriversOutputMatchers.get(i).matches(outPath)) continue;
            this.registeredDrivers.get(i).writeModel(model, outPath);
            return;
        }
        throw new Exception("Unsupported write format for file: " + outPath.toString());
    }
}

