/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.drivers;

import forsyde.io.java.core.EdgeInfo;
import forsyde.io.java.core.EdgeTrait;
import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperties;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.drivers.ForSyDeModelDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ForSyDeXMIDriver
implements ForSyDeModelDriver {
    private static final XPath xPath = XPathFactory.newInstance().newXPath();

    public ForSyDeXMIDriver() {
        xPath.setNamespaceContext(new ForSyDeXMINamespace());
    }

    @Override
    public List<String> inputExtensions() {
        return List.of("forsyde.xmi", "forxmi");
    }

    @Override
    public List<String> outputExtensions() {
        return List.of("forsyde.xmi", "forxmi");
    }

    @Override
    public ForSyDeSystemGraph loadModel(InputStream inStream) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        ForSyDeSystemGraph model = new ForSyDeSystemGraph();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xmlDoc = builder.parse(inStream);
        NodeList vertexList = (NodeList)xPath.compile("/ForSyDeSystemGraph//nodes").evaluate(xmlDoc, XPathConstants.NODESET);
        for (int i = 0; i < vertexList.getLength(); ++i) {
            Element vertexElem = (Element)vertexList.item(i);
            Vertex vertex = new Vertex(vertexElem.getAttribute("identifier"));
            NodeList vertexTraitList = (NodeList)xPath.compile("traits").evaluate(vertexElem, XPathConstants.NODESET);
            for (int j = 0; j < vertexTraitList.getLength(); ++j) {
                String name = vertexTraitList.item(j).getTextContent();
                vertex.vertexTraits.add(VertexTrait.fromName(name));
            }
            model.addVertex(vertex);
            NodeList portsList = (NodeList)xPath.compile("ports").evaluate(vertexElem, XPathConstants.NODESET);
            for (int j = 0; j < portsList.getLength(); ++j) {
                Element portElem = (Element)portsList.item(j);
                vertex.ports.add(portElem.getTextContent());
            }
            NodeList propertyValuesList = (NodeList)xPath.compile("propertiesValues").evaluate(vertexElem, XPathConstants.NODESET);
            NodeList propertyNamesList = (NodeList)xPath.compile("propertiesNames").evaluate(vertexElem, XPathConstants.NODESET);
            for (int j = 0; j < propertyValuesList.getLength(); ++j) {
                Element propertyElem = (Element)propertyValuesList.item(j);
                VertexProperty property = ForSyDeXMIDriver.readData(propertyElem);
                vertex.properties.put(propertyNamesList.item(j).getTextContent(), property);
            }
        }
        NodeList edgeList = (NodeList)xPath.compile("/ForSyDeSystemGraph//edges").evaluate(xmlDoc, XPathConstants.NODESET);
        for (int i = 0; i < edgeList.getLength(); ++i) {
            Element edgeElem = (Element)edgeList.item(i);
            String sid = edgeElem.getAttribute("source");
            String tid = edgeElem.getAttribute("target");
            Vertex source = model.vertexSet().stream().filter(v -> v.getIdentifier().equals(sid)).findFirst().get();
            Vertex target = model.vertexSet().stream().filter(v -> v.getIdentifier().equals(tid)).findFirst().get();
            EdgeInfo edge = new EdgeInfo(source, target);
            NodeList edgeTraitList = (NodeList)xPath.compile("traits").evaluate(edgeElem, XPathConstants.NODESET);
            for (int j = 0; j < edgeTraitList.getLength(); ++j) {
                String name = edgeTraitList.item(j).getTextContent();
                edge.edgeTraits.add(EdgeTrait.fromName(name));
            }
            if (edgeElem.hasAttribute("sourceport")) {
                String sourcePort = source.getPorts().stream().filter(p -> p.equals(edgeElem.getAttribute("sourceport"))).findFirst().get();
                edge.sourcePort = Optional.of(sourcePort);
            }
            if (edgeElem.hasAttribute("targetport")) {
                String targetPort = target.getPorts().stream().filter(p -> p.equals(edgeElem.getAttribute("targetport"))).findFirst().get();
                edge.targetPort = Optional.of(targetPort);
            }
            model.addEdge(source, target, edge);
        }
        return model;
    }

    @Override
    public void writeModel(ForSyDeSystemGraph model, OutputStream outStream) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("forsyde.io.eclipse.systemgraph:ForSyDeSystemGraph");
        root.setAttribute("xmi:version", "2.0");
        root.setAttribute("xmlns:xmi", "http://www.omg.org/XMI");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xmlns:forsyde.io.eclipse.systemgraph", "forsyde.io.eclipse.systemgraph");
        root.setAttribute("xsi:schemaLocation", "forsyde.io.eclipse.systemgraph systemgraph.ecore#//io/eclipse/systemgraph");
        doc.appendChild(root);
        for (Vertex v : model.vertexSet()) {
            Element vElem = doc.createElement("nodes");
            vElem.setAttribute("identifier", v.getIdentifier());
            v.vertexTraits.forEach(t -> {
                Element traitElem = doc.createElement("traits");
                traitElem.setTextContent(t.getName());
                vElem.appendChild(traitElem);
            });
            root.appendChild(vElem);
            for (String p : v.getPorts()) {
                Element pElem = doc.createElement("ports");
                pElem.setTextContent(p);
                vElem.appendChild(pElem);
            }
            for (String key : v.getProperties().keySet()) {
                Element propElem = ForSyDeXMIDriver.writeData(doc, v.getProperties().get(key));
                doc.renameNode(propElem, null, "propertiesValues");
                vElem.appendChild(propElem);
                Element name = doc.createElement("propertiesNames");
                name.setTextContent(key);
                vElem.appendChild(name);
            }
        }
        for (EdgeInfo e : model.edgeSet()) {
            Element eElem = doc.createElement("edges");
            eElem.setAttribute("source", e.getSource());
            eElem.setAttribute("target", e.getTarget());
            e.edgeTraits.forEach(t -> {
                Element traitElem = doc.createElement("traits");
                traitElem.setTextContent(t.getName());
                eElem.appendChild(traitElem);
            });
            if (e.getSourcePort().isPresent()) {
                eElem.setAttribute("sourceport", e.getSourcePort().get());
            }
            if (e.getTargetPort().isPresent()) {
                eElem.setAttribute("targetport", e.getTargetPort().get());
            }
            root.appendChild(eElem);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(doc), new StreamResult(outStream));
    }

    protected static VertexProperty readData(Element elem) throws XPathExpressionException {
        if (elem.getAttribute("xsi:type").equalsIgnoreCase("forsyde.io.eclipse.systemgraph:IntVertexProperty")) {
            return VertexProperty.create(Integer.valueOf(elem.getAttribute("intValue")));
        }
        if (elem.getAttribute("xsi:type").equalsIgnoreCase("forsyde.io.eclipse.systemgraph:FloatVertexProperty")) {
            return VertexProperty.create(Float.valueOf(elem.getAttribute("floatValue")));
        }
        if (elem.getAttribute("xsi:type").equalsIgnoreCase("forsyde.io.eclipse.systemgraph:LongVertexProperty")) {
            return VertexProperty.create(Long.valueOf(elem.getAttribute("longValue")));
        }
        if (elem.getAttribute("xsi:type").equalsIgnoreCase("forsyde.io.eclipse.systemgraph:DoubleVertexProperty")) {
            return VertexProperty.create(Double.valueOf(elem.getAttribute("doubleValue")));
        }
        if (elem.getAttribute("xsi:type").equalsIgnoreCase("forsyde.io.eclipse.systemgraph:BooleanVertexProperty")) {
            return VertexProperty.create(Boolean.valueOf(elem.getAttribute("booleanValue")));
        }
        if (elem.getAttribute("xsi:type").equalsIgnoreCase("forsyde.io.eclipse.systemgraph:IntMapVertexProperty")) {
            HashMap<Integer, VertexProperty> map = new HashMap<Integer, VertexProperty>();
            NodeList children = (NodeList)xPath.compile("values").evaluate(elem, XPathConstants.NODESET);
            NodeList childrenIndexes = (NodeList)xPath.compile("indexes").evaluate(elem, XPathConstants.NODESET);
            for (int i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                map.put(Integer.valueOf(childrenIndexes.item(i).getTextContent()), ForSyDeXMIDriver.readData(child));
            }
            return VertexProperty.create(map);
        }
        if (elem.getAttribute("xsi:type").equalsIgnoreCase("forsyde.io.eclipse.systemgraph:StringMapVertexProperty")) {
            HashMap<String, VertexProperty> map = new HashMap<String, VertexProperty>();
            NodeList children = (NodeList)xPath.compile("values").evaluate(elem, XPathConstants.NODESET);
            NodeList childrenIndexes = (NodeList)xPath.compile("indexes").evaluate(elem, XPathConstants.NODESET);
            for (int i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                map.put(childrenIndexes.item(i).getTextContent(), ForSyDeXMIDriver.readData(child));
            }
            return VertexProperty.create(map);
        }
        if (elem.getAttribute("xsi:type").equalsIgnoreCase("forsyde.io.eclipse.systemgraph:ArrayVertexProperty")) {
            NodeList children = (NodeList)xPath.compile("values").evaluate(elem, XPathConstants.NODESET);
            ArrayList<VertexProperty> array = new ArrayList<VertexProperty>(children.getLength());
            for (int i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                array.add(i, ForSyDeXMIDriver.readData(child));
            }
            return VertexProperty.create(array);
        }
        return VertexProperty.create(elem.getTextContent());
    }

    protected static Element writeData(Document doc, VertexProperty prop) {
        Element newElem = doc.createElement("values");
        return VertexProperties.cases().StringVertexProperty(s -> {
            newElem.setAttribute("xsi:type", "forsyde.io.eclipse.systemgraph:StringVertexProperty");
            newElem.setAttribute("string", (String)s);
            return newElem;
        }).IntVertexProperty(i -> {
            newElem.setAttribute("xsi:type", "forsyde.io.eclipse.systemgraph:IntVertexProperty");
            newElem.setAttribute("intValue", i.toString());
            return newElem;
        }).BooleanVertexProperty(b -> {
            newElem.setAttribute("xsi:type", "forsyde.io.eclipse.systemgraph:BooleanVertexProperty");
            newElem.setAttribute("booleanValue", b.toString());
            return newElem;
        }).FloatVertexProperty(f -> {
            newElem.setAttribute("xsi:type", "forsyde.io.eclipse.systemgraph:FloatVertexProperty");
            newElem.setAttribute("floatValue", f.toString());
            return newElem;
        }).LongVertexProperty(l -> {
            newElem.setAttribute("xsi:type", "forsyde.io.eclipse.systemgraph:LongVertexProperty");
            newElem.setAttribute("longValue", l.toString());
            return newElem;
        }).ArrayVertexProperty(array -> {
            newElem.setAttribute("xsi:type", "forsyde.io.eclipse.systemgraph:ArrayVertexProperty");
            for (VertexProperty vertexProperty : array) {
                Element child = ForSyDeXMIDriver.writeData(doc, vertexProperty);
                newElem.appendChild(child);
            }
            return newElem;
        }).IntMapVertexProperty(intMap -> {
            newElem.setAttribute("xsi:type", "forsyde.io.eclipse.systemgraph:IntMapVertexProperty");
            for (Integer key : intMap.keySet()) {
                Element child = ForSyDeXMIDriver.writeData(doc, (VertexProperty)intMap.get(key));
                Element index = doc.createElement("indexes");
                index.setTextContent(key.toString());
                newElem.appendChild(child);
                newElem.appendChild(index);
            }
            return newElem;
        }).StringMapVertexProperty(stringMap -> {
            newElem.setAttribute("xsi:type", "forsyde.io.eclipse.systemgraph:StringMapVertexProperty");
            for (String key : stringMap.keySet()) {
                Element child = ForSyDeXMIDriver.writeData(doc, (VertexProperty)stringMap.get(key));
                Element index = doc.createElement("indexes");
                index.setTextContent(key.toString());
                newElem.appendChild(child);
                newElem.appendChild(index);
            }
            return newElem;
        }).otherwise_(newElem).apply(prop);
    }

    protected static class ForSyDeXMINamespace
    implements NamespaceContext {
        protected ForSyDeXMINamespace() {
        }

        @Override
        public String getNamespaceURI(String s) {
            if (s.equals("forsydeio") || s.equals("graph") || s.equals("systemgraph") || s.equals("forsyde.io.eclipse.systemgraph")) {
                return "forsyde.io.eclipse.systemgraph";
            }
            if (s.equals("xmi")) {
                return "http://www.omg.org/XMI";
            }
            if (s.equals("xsi")) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            if (s.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
            return null;
        }

        @Override
        public String getPrefix(String s) {
            if (s.equals("forsydeio") || s.equals("graph") || s.equals("systemgraph") || s.equals("forsyde.io.eclipse.systemgraph")) {
                return "forsyde.io.eclipse.systemgraph";
            }
            if (s.equals("http://www.omg.org/XMI")) {
                return "xmi";
            }
            if (s.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                return "xsi";
            }
            if (s.equals("http://www.w3.org/2000/xmlns/")) {
                return "xmlns";
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String s) {
            return null;
        }
    }
}

