/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.decision;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.decision.AllocatedViewer;
import forsyde.io.java.typed.viewers.platform.DigitalModule;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface Allocated
extends VertexViewer {
    default public Set<DigitalModule> getAllocationHostPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getMultipleNamedPort(model, this.getViewedVertex(), "allocationHost", VertexTrait.PLATFORM_DIGITALMODULE, "outgoing").stream().map(v -> DigitalModule.safeCast(v).get()).collect(Collectors.toSet());
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.DECISION_ALLOCATED)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.DECISION_ALLOCATED)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Allocated> safeCast(Vertex vertex) {
        return Allocated.conforms(vertex) != false ? Optional.of(new AllocatedViewer(vertex)) : Optional.empty();
    }

    public static Optional<Allocated> safeCast(VertexViewer viewer) {
        return Allocated.conforms(viewer.getViewedVertex()) != false ? Optional.of(new AllocatedViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of("allocationHost");
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static Allocated enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.DECISION_ALLOCATED);
        vertex.ports.addAll(Allocated.getRequiredPorts());
        for (String key : Allocated.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, Allocated.getRequiredProperties().get(key));
        }
        return new AllocatedViewer(vertex);
    }

    public static Allocated enforce(VertexViewer viewer) {
        return Allocated.enforce(viewer.getViewedVertex());
    }
}

