/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.decision;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.decision.Allocated;
import forsyde.io.java.typed.viewers.decision.MemoryMappedViewer;
import forsyde.io.java.typed.viewers.platform.DigitalModule;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface MemoryMapped
extends Allocated,
VertexViewer {
    default public Set<DigitalModule> getMappingHostPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getMultipleNamedPort(model, this.getViewedVertex(), "mappingHost", VertexTrait.PLATFORM_DIGITALMODULE, "outgoing").stream().map(v -> DigitalModule.safeCast(v).get()).collect(Collectors.toSet());
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.DECISION_MEMORYMAPPED)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.DECISION_MEMORYMAPPED)) continue;
            return true;
        }
        return false;
    }

    public static Optional<MemoryMapped> safeCast(Vertex vertex) {
        return MemoryMapped.conforms(vertex) != false ? Optional.of(new MemoryMappedViewer(vertex)) : Optional.empty();
    }

    public static Optional<MemoryMapped> safeCast(VertexViewer viewer) {
        return MemoryMapped.conforms(viewer.getViewedVertex()) != false ? Optional.of(new MemoryMappedViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of("mappingHost");
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static MemoryMapped enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.DECISION_MEMORYMAPPED);
        vertex.ports.addAll(MemoryMapped.getRequiredPorts());
        for (String key : MemoryMapped.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, MemoryMapped.getRequiredProperties().get(key));
        }
        return new MemoryMappedViewer(vertex);
    }

    public static MemoryMapped enforce(VertexViewer viewer) {
        return MemoryMapped.enforce(viewer.getViewedVertex());
    }
}

