/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.execution.ChannelViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Channel
extends VertexViewer {
    default public Integer getMaxElems() {
        return this.getViewedVertex().getProperties().containsKey("maxElems") ? (Integer)this.getViewedVertex().getProperties().get("maxElems").unwrap() : null;
    }

    default public void setMaxElems(Integer maxElems) {
        this.getViewedVertex().getProperties().put("maxElems", VertexProperty.create(maxElems));
    }

    default public Long getElemSizeInBits() {
        return this.getViewedVertex().getProperties().containsKey("elemSizeInBits") ? (Long)this.getViewedVertex().getProperties().get("elemSizeInBits").unwrap() : null;
    }

    default public void setElemSizeInBits(Long elemSizeInBits) {
        this.getViewedVertex().getProperties().put("elemSizeInBits", VertexProperty.create(elemSizeInBits));
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_CHANNEL)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_CHANNEL)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Channel> safeCast(Vertex vertex) {
        return Channel.conforms(vertex) != false ? Optional.of(new ChannelViewer(vertex)) : Optional.empty();
    }

    public static Optional<Channel> safeCast(VertexViewer viewer) {
        return Channel.conforms(viewer.getViewedVertex()) != false ? Optional.of(new ChannelViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static Channel enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.EXECUTION_CHANNEL);
        vertex.ports.addAll(Channel.getRequiredPorts());
        for (String key : Channel.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, Channel.getRequiredProperties().get(key));
        }
        return new ChannelViewer(vertex);
    }

    public static Channel enforce(VertexViewer viewer) {
        return Channel.enforce(viewer.getViewedVertex());
    }
}

