/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.execution.ColocationConstraintViewer;
import forsyde.io.java.typed.viewers.execution.RuntimeConstraint;
import forsyde.io.java.typed.viewers.execution.Task;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface ColocationConstraint
extends RuntimeConstraint,
VertexViewer {
    default public Set<Task> getCocolatedPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getMultipleNamedPort(model, this.getViewedVertex(), "cocolated", VertexTrait.EXECUTION_TASK, "bidirectional").stream().map(v -> Task.safeCast(v).get()).collect(Collectors.toSet());
    }

    default public Set<Task> getDislocatedPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getMultipleNamedPort(model, this.getViewedVertex(), "dislocated", VertexTrait.EXECUTION_TASK, "bidirectional").stream().map(v -> Task.safeCast(v).get()).collect(Collectors.toSet());
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_COLOCATIONCONSTRAINT)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_COLOCATIONCONSTRAINT)) continue;
            return true;
        }
        return false;
    }

    public static Optional<ColocationConstraint> safeCast(Vertex vertex) {
        return ColocationConstraint.conforms(vertex) != false ? Optional.of(new ColocationConstraintViewer(vertex)) : Optional.empty();
    }

    public static Optional<ColocationConstraint> safeCast(VertexViewer viewer) {
        return ColocationConstraint.conforms(viewer.getViewedVertex()) != false ? Optional.of(new ColocationConstraintViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of("cocolated", "dislocated");
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static ColocationConstraint enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.EXECUTION_COLOCATIONCONSTRAINT);
        vertex.ports.addAll(ColocationConstraint.getRequiredPorts());
        for (String key : ColocationConstraint.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, ColocationConstraint.getRequiredProperties().get(key));
        }
        return new ColocationConstraintViewer(vertex);
    }

    public static ColocationConstraint enforce(VertexViewer viewer) {
        return ColocationConstraint.enforce(viewer.getViewedVertex());
    }
}

