/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.execution.ConstrainedTaskViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ConstrainedTask
extends VertexViewer {
    default public Long getRelativeDeadlineNumerator() {
        return this.getViewedVertex().getProperties().containsKey("relativeDeadlineNumerator") ? (Long)this.getViewedVertex().getProperties().get("relativeDeadlineNumerator").unwrap() : null;
    }

    default public void setRelativeDeadlineNumerator(Long relativeDeadlineNumerator) {
        this.getViewedVertex().getProperties().put("relativeDeadlineNumerator", VertexProperty.create(relativeDeadlineNumerator));
    }

    default public Long getRelativeDeadlineDenominator() {
        return this.getViewedVertex().getProperties().containsKey("relativeDeadlineDenominator") ? (Long)this.getViewedVertex().getProperties().get("relativeDeadlineDenominator").unwrap() : null;
    }

    default public void setRelativeDeadlineDenominator(Long relativeDeadlineDenominator) {
        this.getViewedVertex().getProperties().put("relativeDeadlineDenominator", VertexProperty.create(relativeDeadlineDenominator));
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_CONSTRAINEDTASK)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_CONSTRAINEDTASK)) continue;
            return true;
        }
        return false;
    }

    public static Optional<ConstrainedTask> safeCast(Vertex vertex) {
        return ConstrainedTask.conforms(vertex) != false ? Optional.of(new ConstrainedTaskViewer(vertex)) : Optional.empty();
    }

    public static Optional<ConstrainedTask> safeCast(VertexViewer viewer) {
        return ConstrainedTask.conforms(viewer.getViewedVertex()) != false ? Optional.of(new ConstrainedTaskViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static ConstrainedTask enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.EXECUTION_CONSTRAINEDTASK);
        vertex.ports.addAll(ConstrainedTask.getRequiredPorts());
        for (String key : ConstrainedTask.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, ConstrainedTask.getRequiredProperties().get(key));
        }
        return new ConstrainedTaskViewer(vertex);
    }

    public static ConstrainedTask enforce(VertexViewer viewer) {
        return ConstrainedTask.enforce(viewer.getViewedVertex());
    }
}

