/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.execution.PeriodicStimulusViewer;
import forsyde.io.java.typed.viewers.execution.Stimulus;
import forsyde.io.java.typed.viewers.execution.Task;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface PeriodicStimulus
extends Stimulus,
VertexViewer {
    default public Long getPeriodNumerator() {
        return this.getViewedVertex().getProperties().containsKey("periodNumerator") ? (Long)this.getViewedVertex().getProperties().get("periodNumerator").unwrap() : null;
    }

    default public void setPeriodNumerator(Long periodNumerator) {
        this.getViewedVertex().getProperties().put("periodNumerator", VertexProperty.create(periodNumerator));
    }

    default public Long getPeriodDenominator() {
        return this.getViewedVertex().getProperties().containsKey("periodDenominator") ? (Long)this.getViewedVertex().getProperties().get("periodDenominator").unwrap() : null;
    }

    default public void setPeriodDenominator(Long periodDenominator) {
        this.getViewedVertex().getProperties().put("periodDenominator", VertexProperty.create(periodDenominator));
    }

    default public Long getOffsetNumerator() {
        return this.getViewedVertex().getProperties().containsKey("offsetNumerator") ? (Long)this.getViewedVertex().getProperties().get("offsetNumerator").unwrap() : null;
    }

    default public void setOffsetNumerator(Long offsetNumerator) {
        this.getViewedVertex().getProperties().put("offsetNumerator", VertexProperty.create(offsetNumerator));
    }

    default public Long getOffsetDenominator() {
        return this.getViewedVertex().getProperties().containsKey("offsetDenominator") ? (Long)this.getViewedVertex().getProperties().get("offsetDenominator").unwrap() : null;
    }

    default public void setOffsetDenominator(Long offsetDenominator) {
        this.getViewedVertex().getProperties().put("offsetDenominator", VertexProperty.create(offsetDenominator));
    }

    default public Set<Task> getStimulatedPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getMultipleNamedPort(model, this.getViewedVertex(), "stimulated", VertexTrait.EXECUTION_TASK, "bidirectional").stream().map(v -> Task.safeCast(v).get()).collect(Collectors.toSet());
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_PERIODICSTIMULUS)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_PERIODICSTIMULUS)) continue;
            return true;
        }
        return false;
    }

    public static Optional<PeriodicStimulus> safeCast(Vertex vertex) {
        return PeriodicStimulus.conforms(vertex) != false ? Optional.of(new PeriodicStimulusViewer(vertex)) : Optional.empty();
    }

    public static Optional<PeriodicStimulus> safeCast(VertexViewer viewer) {
        return PeriodicStimulus.conforms(viewer.getViewedVertex()) != false ? Optional.of(new PeriodicStimulusViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of("stimulated");
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static PeriodicStimulus enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.EXECUTION_PERIODICSTIMULUS);
        vertex.ports.addAll(PeriodicStimulus.getRequiredPorts());
        for (String key : PeriodicStimulus.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, PeriodicStimulus.getRequiredProperties().get(key));
        }
        return new PeriodicStimulusViewer(vertex);
    }

    public static PeriodicStimulus enforce(VertexViewer viewer) {
        return PeriodicStimulus.enforce(viewer.getViewedVertex());
    }
}

