/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.execution.PrecedenceConstraintViewer;
import forsyde.io.java.typed.viewers.execution.RuntimeConstraint;
import forsyde.io.java.typed.viewers.execution.Task;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface PrecedenceConstraint
extends RuntimeConstraint,
VertexViewer {
    default public Set<Task> getPredecessorPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getMultipleNamedPort(model, this.getViewedVertex(), "predecessor", VertexTrait.EXECUTION_TASK, "bidirectional").stream().map(v -> Task.safeCast(v).get()).collect(Collectors.toSet());
    }

    default public Set<Task> getSucessorPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getMultipleNamedPort(model, this.getViewedVertex(), "sucessor", VertexTrait.EXECUTION_TASK, "bidirectional").stream().map(v -> Task.safeCast(v).get()).collect(Collectors.toSet());
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_PRECEDENCECONSTRAINT)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_PRECEDENCECONSTRAINT)) continue;
            return true;
        }
        return false;
    }

    public static Optional<PrecedenceConstraint> safeCast(Vertex vertex) {
        return PrecedenceConstraint.conforms(vertex) != false ? Optional.of(new PrecedenceConstraintViewer(vertex)) : Optional.empty();
    }

    public static Optional<PrecedenceConstraint> safeCast(VertexViewer viewer) {
        return PrecedenceConstraint.conforms(viewer.getViewedVertex()) != false ? Optional.of(new PrecedenceConstraintViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of("predecessor", "sucessor");
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static PrecedenceConstraint enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.EXECUTION_PRECEDENCECONSTRAINT);
        vertex.ports.addAll(PrecedenceConstraint.getRequiredPorts());
        for (String key : PrecedenceConstraint.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, PrecedenceConstraint.getRequiredProperties().get(key));
        }
        return new PrecedenceConstraintViewer(vertex);
    }

    public static PrecedenceConstraint enforce(VertexViewer viewer) {
        return PrecedenceConstraint.enforce(viewer.getViewedVertex());
    }
}

