/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.execution.RuntimeConstraintViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface RuntimeConstraint
extends VertexViewer {
    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_RUNTIMECONSTRAINT)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_RUNTIMECONSTRAINT)) continue;
            return true;
        }
        return false;
    }

    public static Optional<RuntimeConstraint> safeCast(Vertex vertex) {
        return RuntimeConstraint.conforms(vertex) != false ? Optional.of(new RuntimeConstraintViewer(vertex)) : Optional.empty();
    }

    public static Optional<RuntimeConstraint> safeCast(VertexViewer viewer) {
        return RuntimeConstraint.conforms(viewer.getViewedVertex()) != false ? Optional.of(new RuntimeConstraintViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static RuntimeConstraint enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.EXECUTION_RUNTIMECONSTRAINT);
        vertex.ports.addAll(RuntimeConstraint.getRequiredPorts());
        for (String key : RuntimeConstraint.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, RuntimeConstraint.getRequiredProperties().get(key));
        }
        return new RuntimeConstraintViewer(vertex);
    }

    public static RuntimeConstraint enforce(VertexViewer viewer) {
        return RuntimeConstraint.enforce(viewer.getViewedVertex());
    }
}

