/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.execution;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.execution.StimulusViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Stimulus
extends VertexViewer {
    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_STIMULUS)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.EXECUTION_STIMULUS)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Stimulus> safeCast(Vertex vertex) {
        return Stimulus.conforms(vertex) != false ? Optional.of(new StimulusViewer(vertex)) : Optional.empty();
    }

    public static Optional<Stimulus> safeCast(VertexViewer viewer) {
        return Stimulus.conforms(viewer.getViewedVertex()) != false ? Optional.of(new StimulusViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static Stimulus enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.EXECUTION_STIMULUS);
        vertex.ports.addAll(Stimulus.getRequiredPorts());
        for (String key : Stimulus.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, Stimulus.getRequiredProperties().get(key));
        }
        return new StimulusViewer(vertex);
    }

    public static Stimulus enforce(VertexViewer viewer) {
        return Stimulus.enforce(viewer.getViewedVertex());
    }
}

