/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.impl;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.impl.ExecutableViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Executable
extends VertexViewer {
    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.IMPL_EXECUTABLE)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.IMPL_EXECUTABLE)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Executable> safeCast(Vertex vertex) {
        return Executable.conforms(vertex) != false ? Optional.of(new ExecutableViewer(vertex)) : Optional.empty();
    }

    public static Optional<Executable> safeCast(VertexViewer viewer) {
        return Executable.conforms(viewer.getViewedVertex()) != false ? Optional.of(new ExecutableViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static Executable enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.IMPL_EXECUTABLE);
        vertex.ports.addAll(Executable.getRequiredPorts());
        for (String key : Executable.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, Executable.getRequiredProperties().get(key));
        }
        return new ExecutableViewer(vertex);
    }

    public static Executable enforce(VertexViewer viewer) {
        return Executable.enforce(viewer.getViewedVertex());
    }
}

