/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.impl;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.impl.Executable;
import forsyde.io.java.typed.viewers.impl.InstrumentedExecutableViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface InstrumentedExecutable
extends Executable,
VertexViewer {
    default public Map<String, Map<String, Long>> getOperationRequirements() {
        return this.getViewedVertex().getProperties().containsKey("operationRequirements") ? (Map)this.getViewedVertex().getProperties().get("operationRequirements").unwrap() : null;
    }

    default public void setOperationRequirements(Map<String, Map<String, Long>> operationRequirements) {
        this.getViewedVertex().getProperties().put("operationRequirements", VertexProperty.create(operationRequirements));
    }

    default public Long getSizeInBits() {
        return this.getViewedVertex().getProperties().containsKey("sizeInBits") ? (Long)this.getViewedVertex().getProperties().get("sizeInBits").unwrap() : null;
    }

    default public void setSizeInBits(Long sizeInBits) {
        this.getViewedVertex().getProperties().put("sizeInBits", VertexProperty.create(sizeInBits));
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.IMPL_INSTRUMENTEDEXECUTABLE)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.IMPL_INSTRUMENTEDEXECUTABLE)) continue;
            return true;
        }
        return false;
    }

    public static Optional<InstrumentedExecutable> safeCast(Vertex vertex) {
        return InstrumentedExecutable.conforms(vertex) != false ? Optional.of(new InstrumentedExecutableViewer(vertex)) : Optional.empty();
    }

    public static Optional<InstrumentedExecutable> safeCast(VertexViewer viewer) {
        return InstrumentedExecutable.conforms(viewer.getViewedVertex()) != false ? Optional.of(new InstrumentedExecutableViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static InstrumentedExecutable enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.IMPL_INSTRUMENTEDEXECUTABLE);
        vertex.ports.addAll(InstrumentedExecutable.getRequiredPorts());
        for (String key : InstrumentedExecutable.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, InstrumentedExecutable.getRequiredProperties().get(key));
        }
        return new InstrumentedExecutableViewer(vertex);
    }

    public static InstrumentedExecutable enforce(VertexViewer viewer) {
        return InstrumentedExecutable.enforce(viewer.getViewedVertex());
    }
}

