/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.moc;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.moc.MoCElemViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface MoCElem
extends VertexViewer {
    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.MOC_MOCELEM)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.MOC_MOCELEM)) continue;
            return true;
        }
        return false;
    }

    public static Optional<MoCElem> safeCast(Vertex vertex) {
        return MoCElem.conforms(vertex) != false ? Optional.of(new MoCElemViewer(vertex)) : Optional.empty();
    }

    public static Optional<MoCElem> safeCast(VertexViewer viewer) {
        return MoCElem.conforms(viewer.getViewedVertex()) != false ? Optional.of(new MoCElemViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static MoCElem enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.MOC_MOCELEM);
        vertex.ports.addAll(MoCElem.getRequiredPorts());
        for (String key : MoCElem.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, MoCElem.getRequiredProperties().get(key));
        }
        return new MoCElemViewer(vertex);
    }

    public static MoCElem enforce(VertexViewer viewer) {
        return MoCElem.enforce(viewer.getViewedVertex());
    }
}

