/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.moc.sdf.SDFChannelViewer;
import forsyde.io.java.typed.viewers.moc.sdf.SDFElem;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface SDFChannel
extends SDFElem,
VertexViewer {
    default public Long getTokenSizeInBits() {
        return this.getViewedVertex().getProperties().containsKey("tokenSizeInBits") ? (Long)this.getViewedVertex().getProperties().get("tokenSizeInBits").unwrap() : null;
    }

    default public void setTokenSizeInBits(Long tokenSizeInBits) {
        this.getViewedVertex().getProperties().put("tokenSizeInBits", VertexProperty.create(tokenSizeInBits));
    }

    default public Optional<SDFElem> getProducerPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getNamedPort(model, this.getViewedVertex(), "producer", VertexTrait.MOC_SDF_SDFELEM, "incoming").map(v -> SDFElem.safeCast(v).get());
    }

    default public Optional<SDFElem> getConsumerPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getNamedPort(model, this.getViewedVertex(), "consumer", VertexTrait.MOC_SDF_SDFELEM, "outgoing").map(v -> SDFElem.safeCast(v).get());
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.MOC_SDF_SDFCHANNEL)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.MOC_SDF_SDFCHANNEL)) continue;
            return true;
        }
        return false;
    }

    public static Optional<SDFChannel> safeCast(Vertex vertex) {
        return SDFChannel.conforms(vertex) != false ? Optional.of(new SDFChannelViewer(vertex)) : Optional.empty();
    }

    public static Optional<SDFChannel> safeCast(VertexViewer viewer) {
        return SDFChannel.conforms(viewer.getViewedVertex()) != false ? Optional.of(new SDFChannelViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of("producer", "consumer");
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static SDFChannel enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.MOC_SDF_SDFCHANNEL);
        vertex.ports.addAll(SDFChannel.getRequiredPorts());
        for (String key : SDFChannel.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, SDFChannel.getRequiredProperties().get(key));
        }
        return new SDFChannelViewer(vertex);
    }

    public static SDFChannel enforce(VertexViewer viewer) {
        return SDFChannel.enforce(viewer.getViewedVertex());
    }
}

