/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.impl.Executable;
import forsyde.io.java.typed.viewers.moc.sdf.SDFCombViewer;
import forsyde.io.java.typed.viewers.moc.sdf.SDFElem;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface SDFComb
extends SDFElem,
VertexViewer {
    default public Map<String, Integer> getConsumption() {
        return this.getViewedVertex().getProperties().containsKey("consumption") ? (Map)this.getViewedVertex().getProperties().get("consumption").unwrap() : null;
    }

    default public void setConsumption(Map<String, Integer> consumption) {
        this.getViewedVertex().getProperties().put("consumption", VertexProperty.create(consumption));
    }

    default public Map<String, Integer> getProduction() {
        return this.getViewedVertex().getProperties().containsKey("production") ? (Map)this.getViewedVertex().getProperties().get("production").unwrap() : null;
    }

    default public void setProduction(Map<String, Integer> production) {
        this.getViewedVertex().getProperties().put("production", VertexProperty.create(production));
    }

    default public Optional<Executable> getCombFunctionPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getNamedPort(model, this.getViewedVertex(), "combFunction", VertexTrait.IMPL_EXECUTABLE, "bidirectional").map(v -> Executable.safeCast(v).get());
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.MOC_SDF_SDFCOMB)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.MOC_SDF_SDFCOMB)) continue;
            return true;
        }
        return false;
    }

    public static Optional<SDFComb> safeCast(Vertex vertex) {
        return SDFComb.conforms(vertex) != false ? Optional.of(new SDFCombViewer(vertex)) : Optional.empty();
    }

    public static Optional<SDFComb> safeCast(VertexViewer viewer) {
        return SDFComb.conforms(viewer.getViewedVertex()) != false ? Optional.of(new SDFCombViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of("combFunction");
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static SDFComb enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.MOC_SDF_SDFCOMB);
        vertex.ports.addAll(SDFComb.getRequiredPorts());
        for (String key : SDFComb.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, SDFComb.getRequiredProperties().get(key));
        }
        return new SDFCombViewer(vertex);
    }

    public static SDFComb enforce(VertexViewer viewer) {
        return SDFComb.enforce(viewer.getViewedVertex());
    }
}

