/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.moc.sdf;

import forsyde.io.java.core.ForSyDeSystemGraph;
import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexAcessor;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.impl.Executable;
import forsyde.io.java.typed.viewers.moc.sdf.SDFChannel;
import forsyde.io.java.typed.viewers.moc.sdf.SDFDelayViewer;
import forsyde.io.java.typed.viewers.moc.sdf.SDFElem;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface SDFDelay
extends SDFElem,
VertexViewer {
    default public Integer getDelayedTokens() {
        return this.getViewedVertex().getProperties().containsKey("delayedTokens") ? (Integer)this.getViewedVertex().getProperties().get("delayedTokens").unwrap() : null;
    }

    default public void setDelayedTokens(Integer delayedTokens) {
        this.getViewedVertex().getProperties().put("delayedTokens", VertexProperty.create(delayedTokens));
    }

    default public Optional<Executable> getDelayFunctionPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getNamedPort(model, this.getViewedVertex(), "delayFunction", VertexTrait.IMPL_EXECUTABLE, "bidirectional").map(v -> Executable.safeCast(v).get());
    }

    default public Optional<SDFChannel> getNotDelayedChannelPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getNamedPort(model, this.getViewedVertex(), "notDelayedChannel", VertexTrait.MOC_SDF_SDFCHANNEL, "incoming").map(v -> SDFChannel.safeCast(v).get());
    }

    default public Optional<SDFChannel> getDelayedChannelPort(ForSyDeSystemGraph model) {
        return VertexAcessor.getNamedPort(model, this.getViewedVertex(), "delayedChannel", VertexTrait.MOC_SDF_SDFCHANNEL, "outgoing").map(v -> SDFChannel.safeCast(v).get());
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.MOC_SDF_SDFDELAY)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.MOC_SDF_SDFDELAY)) continue;
            return true;
        }
        return false;
    }

    public static Optional<SDFDelay> safeCast(Vertex vertex) {
        return SDFDelay.conforms(vertex) != false ? Optional.of(new SDFDelayViewer(vertex)) : Optional.empty();
    }

    public static Optional<SDFDelay> safeCast(VertexViewer viewer) {
        return SDFDelay.conforms(viewer.getViewedVertex()) != false ? Optional.of(new SDFDelayViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of("delayFunction", "notDelayedChannel", "delayedChannel");
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static SDFDelay enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.MOC_SDF_SDFDELAY);
        vertex.ports.addAll(SDFDelay.getRequiredPorts());
        for (String key : SDFDelay.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, SDFDelay.getRequiredProperties().get(key));
        }
        return new SDFDelayViewer(vertex);
    }

    public static SDFDelay enforce(VertexViewer viewer) {
        return SDFDelay.enforce(viewer.getViewedVertex());
    }
}

