/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.DigitalModuleViewer;
import forsyde.io.java.typed.viewers.platform.PlatformElem;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface DigitalModule
extends PlatformElem,
VertexViewer {
    default public Long getOperatingFrequencyInHertz() {
        return this.getViewedVertex().getProperties().containsKey("operatingFrequencyInHertz") ? (Long)this.getViewedVertex().getProperties().get("operatingFrequencyInHertz").unwrap() : null;
    }

    default public void setOperatingFrequencyInHertz(Long operatingFrequencyInHertz) {
        this.getViewedVertex().getProperties().put("operatingFrequencyInHertz", VertexProperty.create(operatingFrequencyInHertz));
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_DIGITALMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_DIGITALMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Optional<DigitalModule> safeCast(Vertex vertex) {
        return DigitalModule.conforms(vertex) != false ? Optional.of(new DigitalModuleViewer(vertex)) : Optional.empty();
    }

    public static Optional<DigitalModule> safeCast(VertexViewer viewer) {
        return DigitalModule.conforms(viewer.getViewedVertex()) != false ? Optional.of(new DigitalModuleViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static DigitalModule enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_DIGITALMODULE);
        vertex.ports.addAll(DigitalModule.getRequiredPorts());
        for (String key : DigitalModule.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, DigitalModule.getRequiredProperties().get(key));
        }
        return new DigitalModuleViewer(vertex);
    }

    public static DigitalModule enforce(VertexViewer viewer) {
        return DigitalModule.enforce(viewer.getViewedVertex());
    }
}

