/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.DigitalModule;
import forsyde.io.java.typed.viewers.platform.GenericCacheModuleViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface GenericCacheModule
extends DigitalModule,
VertexViewer {
    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_GENERICCACHEMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_GENERICCACHEMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Optional<GenericCacheModule> safeCast(Vertex vertex) {
        return GenericCacheModule.conforms(vertex) != false ? Optional.of(new GenericCacheModuleViewer(vertex)) : Optional.empty();
    }

    public static Optional<GenericCacheModule> safeCast(VertexViewer viewer) {
        return GenericCacheModule.conforms(viewer.getViewedVertex()) != false ? Optional.of(new GenericCacheModuleViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static GenericCacheModule enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_GENERICCACHEMODULE);
        vertex.ports.addAll(GenericCacheModule.getRequiredPorts());
        for (String key : GenericCacheModule.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, GenericCacheModule.getRequiredProperties().get(key));
        }
        return new GenericCacheModuleViewer(vertex);
    }

    public static GenericCacheModule enforce(VertexViewer viewer) {
        return GenericCacheModule.enforce(viewer.getViewedVertex());
    }
}

