/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.DigitalModule;
import forsyde.io.java.typed.viewers.platform.GenericCommunicationModuleViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface GenericCommunicationModule
extends DigitalModule,
VertexViewer {
    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_GENERICCOMMUNICATIONMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_GENERICCOMMUNICATIONMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Optional<GenericCommunicationModule> safeCast(Vertex vertex) {
        return GenericCommunicationModule.conforms(vertex) != false ? Optional.of(new GenericCommunicationModuleViewer(vertex)) : Optional.empty();
    }

    public static Optional<GenericCommunicationModule> safeCast(VertexViewer viewer) {
        return GenericCommunicationModule.conforms(viewer.getViewedVertex()) != false ? Optional.of(new GenericCommunicationModuleViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static GenericCommunicationModule enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_GENERICCOMMUNICATIONMODULE);
        vertex.ports.addAll(GenericCommunicationModule.getRequiredPorts());
        for (String key : GenericCommunicationModule.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, GenericCommunicationModule.getRequiredProperties().get(key));
        }
        return new GenericCommunicationModuleViewer(vertex);
    }

    public static GenericCommunicationModule enforce(VertexViewer viewer) {
        return GenericCommunicationModule.enforce(viewer.getViewedVertex());
    }
}

