/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.DigitalModule;
import forsyde.io.java.typed.viewers.platform.GenericMemoryModuleViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface GenericMemoryModule
extends DigitalModule,
VertexViewer {
    default public Long getSpaceInBits() {
        return this.getViewedVertex().getProperties().containsKey("spaceInBits") ? (Long)this.getViewedVertex().getProperties().get("spaceInBits").unwrap() : null;
    }

    default public void setSpaceInBits(Long spaceInBits) {
        this.getViewedVertex().getProperties().put("spaceInBits", VertexProperty.create(spaceInBits));
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_GENERICMEMORYMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_GENERICMEMORYMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Optional<GenericMemoryModule> safeCast(Vertex vertex) {
        return GenericMemoryModule.conforms(vertex) != false ? Optional.of(new GenericMemoryModuleViewer(vertex)) : Optional.empty();
    }

    public static Optional<GenericMemoryModule> safeCast(VertexViewer viewer) {
        return GenericMemoryModule.conforms(viewer.getViewedVertex()) != false ? Optional.of(new GenericMemoryModuleViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static GenericMemoryModule enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_GENERICMEMORYMODULE);
        vertex.ports.addAll(GenericMemoryModule.getRequiredPorts());
        for (String key : GenericMemoryModule.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, GenericMemoryModule.getRequiredProperties().get(key));
        }
        return new GenericMemoryModuleViewer(vertex);
    }

    public static GenericMemoryModule enforce(VertexViewer viewer) {
        return GenericMemoryModule.enforce(viewer.getViewedVertex());
    }
}

