/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.DigitalModule;
import forsyde.io.java.typed.viewers.platform.GenericProcessingModuleViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface GenericProcessingModule
extends DigitalModule,
VertexViewer {
    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_GENERICPROCESSINGMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_GENERICPROCESSINGMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Optional<GenericProcessingModule> safeCast(Vertex vertex) {
        return GenericProcessingModule.conforms(vertex) != false ? Optional.of(new GenericProcessingModuleViewer(vertex)) : Optional.empty();
    }

    public static Optional<GenericProcessingModule> safeCast(VertexViewer viewer) {
        return GenericProcessingModule.conforms(viewer.getViewedVertex()) != false ? Optional.of(new GenericProcessingModuleViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static GenericProcessingModule enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_GENERICPROCESSINGMODULE);
        vertex.ports.addAll(GenericProcessingModule.getRequiredPorts());
        for (String key : GenericProcessingModule.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, GenericProcessingModule.getRequiredProperties().get(key));
        }
        return new GenericProcessingModuleViewer(vertex);
    }

    public static GenericProcessingModule enforce(VertexViewer viewer) {
        return GenericProcessingModule.enforce(viewer.getViewedVertex());
    }
}

