/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.GenericCommunicationModule;
import forsyde.io.java.typed.viewers.platform.InstrumentedCommunicationModuleViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface InstrumentedCommunicationModule
extends GenericCommunicationModule,
VertexViewer {
    default public Long getFlitSizeInBits() {
        return this.getViewedVertex().getProperties().containsKey("flitSizeInBits") ? (Long)this.getViewedVertex().getProperties().get("flitSizeInBits").unwrap() : null;
    }

    default public void setFlitSizeInBits(Long flitSizeInBits) {
        this.getViewedVertex().getProperties().put("flitSizeInBits", VertexProperty.create(flitSizeInBits));
    }

    default public Integer getMaxCyclesPerFlit() {
        return this.getViewedVertex().getProperties().containsKey("maxCyclesPerFlit") ? (Integer)this.getViewedVertex().getProperties().get("maxCyclesPerFlit").unwrap() : null;
    }

    default public void setMaxCyclesPerFlit(Integer maxCyclesPerFlit) {
        this.getViewedVertex().getProperties().put("maxCyclesPerFlit", VertexProperty.create(maxCyclesPerFlit));
    }

    default public Integer getMaxConcurrentFlits() {
        return this.getViewedVertex().getProperties().containsKey("maxConcurrentFlits") ? (Integer)this.getViewedVertex().getProperties().get("maxConcurrentFlits").unwrap() : null;
    }

    default public void setMaxConcurrentFlits(Integer maxConcurrentFlits) {
        this.getViewedVertex().getProperties().put("maxConcurrentFlits", VertexProperty.create(maxConcurrentFlits));
    }

    default public Long getInitialLatency() {
        return this.getViewedVertex().getProperties().containsKey("initialLatency") ? (Long)this.getViewedVertex().getProperties().get("initialLatency").unwrap() : null;
    }

    default public void setInitialLatency(Long initialLatency) {
        this.getViewedVertex().getProperties().put("initialLatency", VertexProperty.create(initialLatency));
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Optional<InstrumentedCommunicationModule> safeCast(Vertex vertex) {
        return InstrumentedCommunicationModule.conforms(vertex) != false ? Optional.of(new InstrumentedCommunicationModuleViewer(vertex)) : Optional.empty();
    }

    public static Optional<InstrumentedCommunicationModule> safeCast(VertexViewer viewer) {
        return InstrumentedCommunicationModule.conforms(viewer.getViewedVertex()) != false ? Optional.of(new InstrumentedCommunicationModuleViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static InstrumentedCommunicationModule enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_INSTRUMENTEDCOMMUNICATIONMODULE);
        vertex.ports.addAll(InstrumentedCommunicationModule.getRequiredPorts());
        for (String key : InstrumentedCommunicationModule.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, InstrumentedCommunicationModule.getRequiredProperties().get(key));
        }
        return new InstrumentedCommunicationModuleViewer(vertex);
    }

    public static InstrumentedCommunicationModule enforce(VertexViewer viewer) {
        return InstrumentedCommunicationModule.enforce(viewer.getViewedVertex());
    }
}

