/*
 * Decompiled with CFR 0.152.
 */
package forsyde.io.java.typed.viewers.platform;

import forsyde.io.java.core.Trait;
import forsyde.io.java.core.Vertex;
import forsyde.io.java.core.VertexProperty;
import forsyde.io.java.core.VertexTrait;
import forsyde.io.java.core.VertexViewer;
import forsyde.io.java.typed.viewers.platform.GenericProcessingModule;
import forsyde.io.java.typed.viewers.platform.InstrumentedProcessingModuleViewer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface InstrumentedProcessingModule
extends GenericProcessingModule,
VertexViewer {
    default public Map<String, Map<String, Double>> getModalInstructionsPerCycle() {
        return this.getViewedVertex().getProperties().containsKey("modalInstructionsPerCycle") ? (Map)this.getViewedVertex().getProperties().get("modalInstructionsPerCycle").unwrap() : null;
    }

    default public void setModalInstructionsPerCycle(Map<String, Map<String, Double>> modalInstructionsPerCycle) {
        this.getViewedVertex().getProperties().put("modalInstructionsPerCycle", VertexProperty.create(modalInstructionsPerCycle));
    }

    public static Boolean conforms(Vertex vertex) {
        for (Trait t : vertex.getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_INSTRUMENTEDPROCESSINGMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Boolean conforms(VertexViewer viewer) {
        for (Trait t : viewer.getViewedVertex().getTraits()) {
            if (!t.refines(VertexTrait.PLATFORM_INSTRUMENTEDPROCESSINGMODULE)) continue;
            return true;
        }
        return false;
    }

    public static Optional<InstrumentedProcessingModule> safeCast(Vertex vertex) {
        return InstrumentedProcessingModule.conforms(vertex) != false ? Optional.of(new InstrumentedProcessingModuleViewer(vertex)) : Optional.empty();
    }

    public static Optional<InstrumentedProcessingModule> safeCast(VertexViewer viewer) {
        return InstrumentedProcessingModule.conforms(viewer.getViewedVertex()) != false ? Optional.of(new InstrumentedProcessingModuleViewer(viewer.getViewedVertex())) : Optional.empty();
    }

    public static Set<String> getRequiredPorts() {
        return Set.of();
    }

    public static Map<String, VertexProperty> getRequiredProperties() {
        return Map.of();
    }

    public static InstrumentedProcessingModule enforce(Vertex vertex) {
        vertex.addTraits(VertexTrait.PLATFORM_INSTRUMENTEDPROCESSINGMODULE);
        vertex.ports.addAll(InstrumentedProcessingModule.getRequiredPorts());
        for (String key : InstrumentedProcessingModule.getRequiredProperties().keySet()) {
            vertex.properties.putIfAbsent(key, InstrumentedProcessingModule.getRequiredProperties().get(key));
        }
        return new InstrumentedProcessingModuleViewer(vertex);
    }

    public static InstrumentedProcessingModule enforce(VertexViewer viewer) {
        return InstrumentedProcessingModule.enforce(viewer.getViewedVertex());
    }
}

